/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReplyPayload;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionTargetEntity;
import io.gravitee.rest.api.service.cockpit.command.CockpitCommandService;
import io.gravitee.rest.api.service.cockpit.command.bridge.BridgeCommandFactory;
import io.gravitee.rest.api.service.cockpit.services.CockpitPromotionService;
import io.gravitee.rest.api.service.cockpit.services.CockpitReply;
import io.gravitee.rest.api.service.cockpit.services.CockpitReplyStatus;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CockpitPromotionServiceImpl
implements CockpitPromotionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CockpitPromotionServiceImpl.class);
    private final BridgeCommandFactory bridgeCommandFactory;
    private final CockpitCommandService cockpitCommandService;
    private final ObjectMapper objectMapper;

    @Override
    public CockpitReply<List<PromotionTargetEntity>> listPromotionTargets(String organizationId, String environmentId) {
        BridgeCommand listEnvironmentCommand = this.bridgeCommandFactory.createListEnvironmentCommand(organizationId, environmentId);
        BridgeReply bridgeReply = this.cockpitCommandService.send(listEnvironmentCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            log.warn("Problem while listing promotion targets through cockpit. \n {}", (Object)bridgeReply.getErrorDetails());
            return new CockpitReply<List<PromotionTargetEntity>>(Collections.emptyList(), CockpitReplyStatus.ERROR);
        }
        List<PromotionTargetEntity> environmentEntities = ((BridgeReplyPayload)bridgeReply.getPayload()).contents().stream().filter(bridgeReplyContent -> bridgeReplyContent.getContent() != null).map(bridgeReplyContent -> {
            try {
                EnvironmentEntity environmentEntity = (EnvironmentEntity)this.objectMapper.readValue(bridgeReplyContent.getContent(), EnvironmentEntity.class);
                return new PromotionTargetEntity(environmentEntity, bridgeReplyContent.getOrganizationId(), bridgeReplyContent.getEnvironmentId(), bridgeReplyContent.getInstallationId());
            }
            catch (JsonProcessingException e) {
                log.warn("Problem while deserializing environment {} with payload {}", (Object)bridgeReplyContent.getEnvironmentId(), (Object)bridgeReplyContent.getContent());
                return null;
            }
        }).filter(Objects::nonNull).toList();
        return new CockpitReply<List<PromotionTargetEntity>>(environmentEntities, CockpitReplyStatus.SUCCEEDED);
    }

    @Override
    public CockpitReply<PromotionEntity> requestPromotion(ExecutionContext executionContext, PromotionEntity promotionEntity) {
        String serializedPromotion = null;
        try {
            serializedPromotion = this.objectMapper.writeValueAsString((Object)promotionEntity);
        }
        catch (JsonProcessingException e) {
            log.warn("Problem while serializing promotion {}", (Object)promotionEntity.getId());
        }
        BridgeCommand promoteApiCommand = this.bridgeCommandFactory.createPromoteApiCommand(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), promotionEntity.getTargetEnvCockpitId(), serializedPromotion);
        BridgeReply bridgeReply = this.cockpitCommandService.send(promoteApiCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            log.warn("Problem while sending API promotion request through cockpit. \n {}", (Object)bridgeReply.getErrorDetails());
            return new CockpitReply<Object>(null, CockpitReplyStatus.ERROR);
        }
        return new CockpitReply<PromotionEntity>(promotionEntity, CockpitReplyStatus.SUCCEEDED);
    }

    @Override
    public CockpitReply<PromotionEntity> processPromotion(ExecutionContext executionContext, PromotionEntity promotionEntity) {
        String serializedPromotion = null;
        try {
            serializedPromotion = this.objectMapper.writeValueAsString((Object)promotionEntity);
        }
        catch (JsonProcessingException e) {
            log.warn("Problem while serializing promotion {}", (Object)promotionEntity.getId());
        }
        BridgeCommand processPromotionCommand = this.bridgeCommandFactory.createProcessPromotionCommand(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), promotionEntity.getSourceEnvCockpitId(), serializedPromotion);
        BridgeReply bridgeReply = this.cockpitCommandService.send(processPromotionCommand);
        if (bridgeReply.getCommandStatus() != CommandStatus.SUCCEEDED) {
            log.warn("Problem while processing API promotion request through cockpit. \n {}", (Object)bridgeReply.getErrorDetails());
            return new CockpitReply<Object>(null, CockpitReplyStatus.ERROR);
        }
        return new CockpitReply<PromotionEntity>(promotionEntity, CockpitReplyStatus.SUCCEEDED);
    }

    @Generated
    public CockpitPromotionServiceImpl(BridgeCommandFactory bridgeCommandFactory, CockpitCommandService cockpitCommandService, ObjectMapper objectMapper) {
        this.bridgeCommandFactory = bridgeCommandFactory;
        this.cockpitCommandService = cockpitCommandService;
        this.objectMapper = objectMapper;
    }
}

