/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class GroupInvitationForbiddenException
extends AbstractNotFoundException {
    private final String type;
    private final String group;

    public GroupInvitationForbiddenException(Type type, String group) {
        this.type = type.name().toLowerCase();
        this.group = group;
    }

    @Override
    public String getMessage() {
        return "Invitation " + this.type + " is forbidden for group [" + this.group + "]";
    }

    @Override
    public String getTechnicalCode() {
        return "group.invitation.forbidden";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("type", this.type);
        parameters.put("group", this.group);
        return parameters;
    }

    public static enum Type {
        EMAIL,
        SYSTEM;

    }
}

