/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.model.mapper.KeyStoreMigration;
import io.gravitee.apim.core.api.model.mapper.TrustStoreMigration;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.ProtocolVersion;
import io.gravitee.definition.model.v4.ssl.SslOptions;
import java.util.Set;
import lombok.Generated;

public class SharedConfigurationMigration {
    private static final Set<String> HTTP11_ALLOWED = Set.of("version", "keepAlive", "keepAliveTimeout", "connectTimeout", "pipelining", "readTimeout", "useCompression", "propagateClientAcceptEncoding", "propagateClientHost", "idleTimeout", "followRedirects", "maxConcurrentConnections");
    private static final Set<String> HTTP2_ALLOWED = Set.of("version", "clearTextUpgrade", "keepAlive", "keepAliveTimeout", "connectTimeout", "pipelining", "readTimeout", "useCompression", "propagateClientAcceptEncoding", "propagateClientHost", "idleTimeout", "followRedirects", "maxConcurrentConnections", "http2MultiplexingLimit");
    private final ObjectMapper objectMapper;

    public String convert(EndpointGroup source) throws JsonProcessingException {
        ObjectNode httpClientOptions = this.mapHttpClientOptions(source.getHttpClientOptions());
        ObjectNode httpClientSslOptionsNode = this.mapHttpClientSslOptions(source.getHttpClientSslOptions());
        ObjectNode sharedConfiguration = this.objectMapper.createObjectNode();
        if (httpClientOptions != null) {
            sharedConfiguration.set("http", (JsonNode)httpClientOptions);
        }
        if (httpClientSslOptionsNode != null) {
            sharedConfiguration.set("ssl", (JsonNode)httpClientSslOptionsNode);
        }
        if (source.getHeaders() != null) {
            sharedConfiguration.set("headers", this.objectMapper.valueToTree((Object)source.getHeaders()));
        }
        if (source.getHttpProxy() != null) {
            sharedConfiguration.set("proxy", this.objectMapper.valueToTree((Object)source.getHttpProxy()));
        }
        return this.objectMapper.writeValueAsString((Object)sharedConfiguration);
    }

    private ObjectNode mapHttpClientOptions(HttpClientOptions httpClientOptions) {
        if (httpClientOptions == null) {
            return null;
        }
        io.gravitee.definition.model.v4.http.HttpClientOptions v4 = new io.gravitee.definition.model.v4.http.HttpClientOptions();
        io.gravitee.definition.model.v4.http.ProtocolVersion versionV4 = httpClientOptions.getVersion() == ProtocolVersion.HTTP_1_1 ? io.gravitee.definition.model.v4.http.ProtocolVersion.HTTP_1_1 : io.gravitee.definition.model.v4.http.ProtocolVersion.HTTP_2;
        v4.setVersion(versionV4);
        v4.setKeepAlive(httpClientOptions.isKeepAlive());
        v4.setPipelining(httpClientOptions.isPipelining());
        v4.setUseCompression(httpClientOptions.isUseCompression());
        v4.setPropagateClientAcceptEncoding(httpClientOptions.isPropagateClientAcceptEncoding());
        v4.setFollowRedirects(httpClientOptions.isFollowRedirects());
        v4.setMaxConcurrentConnections(httpClientOptions.getMaxConcurrentConnections());
        v4.setIdleTimeout(httpClientOptions.getIdleTimeout());
        v4.setKeepAliveTimeout(httpClientOptions.getKeepAliveTimeout());
        v4.setConnectTimeout(httpClientOptions.getConnectTimeout());
        v4.setReadTimeout(httpClientOptions.getReadTimeout());
        if (versionV4 == io.gravitee.definition.model.v4.http.ProtocolVersion.HTTP_2) {
            v4.setClearTextUpgrade(httpClientOptions.isClearTextUpgrade());
        }
        ObjectNode node = (ObjectNode)this.objectMapper.valueToTree((Object)v4);
        return versionV4 == io.gravitee.definition.model.v4.http.ProtocolVersion.HTTP_1_1 ? node.retain(HTTP11_ALLOWED) : node.retain(HTTP2_ALLOWED);
    }

    private ObjectNode mapHttpClientSslOptions(HttpClientSslOptions httpClientSslOptions) {
        if (httpClientSslOptions == null) {
            return null;
        }
        SslOptions sslOptionsV4 = new SslOptions();
        sslOptionsV4.setHostnameVerifier(httpClientSslOptions.isHostnameVerifier());
        sslOptionsV4.setTrustAll(httpClientSslOptions.isTrustAll());
        sslOptionsV4.setTrustStore(TrustStoreMigration.convert(httpClientSslOptions.getTrustStore()));
        sslOptionsV4.setKeyStore(KeyStoreMigration.convert(httpClientSslOptions.getKeyStore()));
        return (ObjectNode)this.objectMapper.valueToTree((Object)sslOptionsV4);
    }

    @Generated
    public SharedConfigurationMigration(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

