/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.mapper.ApiServicesMigration;
import io.gravitee.apim.core.api.model.mapper.SharedConfigurationMigration;
import io.gravitee.apim.core.api.model.utils.MigrationResult;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.LoadBalancerType;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Service;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import io.gravitee.definition.model.services.schedule.ScheduledService;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.analytics.logging.Logging;
import io.gravitee.definition.model.v4.analytics.logging.LoggingContent;
import io.gravitee.definition.model.v4.analytics.logging.LoggingMode;
import io.gravitee.definition.model.v4.analytics.logging.LoggingPhase;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancer;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import io.gravitee.definition.model.v4.failover.Failover;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.flow.execution.FlowMode;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.service.ApiServices;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMigration.class);
    public static final String HTTP_PROXY = "http-proxy";
    private static final String TYPE_ENDPOINT = "ENDPOINT";
    private static final String TYPE_ENDPOINTGROUP = "ENDPOINTGROUP";
    public static final String CONSUL_DISCOVERY_SERVICE_TYPE = "consul-service-discovery";
    public static final String HTTP_HEALTH_CHECK_SERVICE_TYPE = "http-health-check";
    private final ObjectMapper jsonMapper;
    private final ApiServicesMigration apiServicesMigration;
    private final SharedConfigurationMigration sharedConfigurationMigration;

    public ApiMigration(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.apiServicesMigration = new ApiServicesMigration(jsonMapper);
        this.sharedConfigurationMigration = new SharedConfigurationMigration(jsonMapper);
    }

    MigrationResult<Api> mapApi(Api source) {
        return this.apiDefinitionHttpV4(source.getApiDefinition()).map(definition -> ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)source.toBuilder().definitionVersion(DefinitionVersion.V4)).apiDefinitionHttpV4((io.gravitee.definition.model.v4.Api)definition)).apiDefinition(null)).type(ApiType.PROXY)).build());
    }

    private MigrationResult<io.gravitee.definition.model.v4.Api> apiDefinitionHttpV4(io.gravitee.definition.model.Api apiDefinitionV2) {
        if (apiDefinitionV2 == null) {
            return MigrationResult.issue("V2 API should not be null, for migrating to V4", MigrationResult.State.IMPOSSIBLE);
        }
        List<HttpListener> listeners = List.of(((HttpListener.HttpListenerBuilder)((HttpListener.HttpListenerBuilder)((HttpListener.HttpListenerBuilder)HttpListener.builder().cors(apiDefinitionV2.getProxy().getCors()).servers(apiDefinitionV2.getProxy().getServers())).type(ListenerType.HTTP)).paths(CollectionUtils.stream(apiDefinitionV2.getProxy().getVirtualHosts()).map(e -> new Path(e.getHost(), this.addSlashIfNeeded(e.getPath()), e.isOverrideEntrypoint())).toList()).pathMappingsPattern(apiDefinitionV2.getPathMappings()).entrypoints(List.of(((Entrypoint.EntrypointBuilder)Entrypoint.builder().type(HTTP_PROXY)).build()))).build());
        Analytics analytics = this.mapAnalytics(apiDefinitionV2.getProxy().getLogging());
        MigrationResult<List<List>> endpointGroups = CollectionUtils.stream(apiDefinitionV2.getProxy().getGroups()).map(source -> this.mapEndpointGroup((io.gravitee.definition.model.EndpointGroup)source, apiDefinitionV2.getServices())).collect(MigrationResult.collectList());
        Failover failover = this.mapFailOver(apiDefinitionV2.getProxy());
        MigrationResult<ApiServices> apiServicesMigrationResult = this.mapApiServices(apiDefinitionV2.getServices());
        return endpointGroups.flatMap(endpointGroupsList -> apiServicesMigrationResult.map(apiServices -> {
            io.gravitee.definition.model.v4.Api api = new io.gravitee.definition.model.v4.Api(listeners, endpointGroupsList, analytics, failover, null, null, null, apiDefinitionV2.getResponseTemplates(), apiServices);
            api.setId(apiDefinitionV2.getId());
            api.setName(apiDefinitionV2.getName());
            api.setApiVersion(apiDefinitionV2.getVersion());
            api.setTags(apiDefinitionV2.getTags());
            api.setType(ApiType.PROXY);
            api.setProperties(this.mapProperties(apiDefinitionV2.getProperties()));
            api.setResources(this.mapResources(apiDefinitionV2.getResources()));
            api.setFlowExecution(this.mapFlowExecution(apiDefinitionV2.getFlowMode()));
            return api;
        }));
    }

    private MigrationResult<ApiServices> mapApiServices(Services services) {
        if (services == null || services.isEmpty() || services.getDynamicPropertyService() == null) {
            return MigrationResult.value(ApiServices.builder().build());
        }
        MigrationResult<io.gravitee.definition.model.v4.service.Service> dynamicPropertyServiceMigrationResult = this.apiServicesMigration.convert((Service)services.getDynamicPropertyService(), null, null);
        return dynamicPropertyServiceMigrationResult.map(service -> ApiServices.builder().dynamicProperty(service).build());
    }

    private Failover mapFailOver(Proxy proxy) {
        return proxy.failoverEnabled() ? Failover.builder().enabled(proxy.failoverEnabled()).slowCallDuration(proxy.getFailover().getRetryTimeout()).maxRetries(proxy.getFailover().getMaxAttempts()).build() : null;
    }

    private MigrationResult<EndpointGroup> mapEndpointGroup(io.gravitee.definition.model.EndpointGroup source, Services endpointServices) {
        MigrationResult<EndpointGroupServices> endpointGroupServicesMigrationResult = this.mapEndpointGroupServices(endpointServices, source.getServices(), source.getName());
        MigrationResult<List<Object>> endpoints = MigrationResult.value(List.of());
        MigrationResult<EndpointGroup> endpointGroupMigrationResult = MigrationResult.value(((EndpointGroup.EndpointGroupBuilder)((EndpointGroup.EndpointGroupBuilder)((EndpointGroup.EndpointGroupBuilder)EndpointGroup.builder().name(source.getName())).type(HTTP_PROXY)).loadBalancer(this.mapLoadBalancer(source.getLoadBalancer()))).build());
        String sharedConfiguration = null;
        try {
            sharedConfiguration = this.sharedConfigurationMigration.convert(source);
            endpoints = CollectionUtils.stream(source.getEndpoints()).map(this::mapEndpoint).collect(MigrationResult.collectList());
        }
        catch (JsonProcessingException e) {
            log.error("Unable to map configuration for endpoint group {}", (Object)source.getName(), (Object)e);
            endpointGroupMigrationResult.addIssue(new MigrationResult.Issue("Unable to migrate the API, as an error occurred while parsing the configuration for endpoint group, %s. Please contact support and attach your API definition with the support ticket for debugging".formatted(source.getName()), MigrationResult.State.IMPOSSIBLE));
        }
        return endpointGroupMigrationResult.foldLeft(endpointGroupServicesMigrationResult, (egp, egs) -> {
            if (egp != null) {
                egp.setServices(egs);
            }
            return egp;
        }).foldLeft(endpoints, (egp, b) -> {
            if (egp != null) {
                egp.setEndpoints(b);
            }
            return egp;
        }).foldLeft(MigrationResult.value(sharedConfiguration), (egp, b) -> {
            if (egp != null) {
                egp.setSharedConfiguration(b);
            }
            return egp;
        });
    }

    private MigrationResult<EndpointGroupServices> mapEndpointGroupServices(Services endpointServices, Services endpointGroupServices, String name) {
        if (endpointServices == null && endpointGroupServices == null) {
            return MigrationResult.value(new EndpointGroupServices());
        }
        MigrationResult<List<List>> migratedServices = Stream.of(endpointServices, endpointGroupServices).filter(Objects::nonNull).flatMap(s -> s.getAll().stream()).filter(s -> !(s instanceof ScheduledService) || ((ScheduledService)s).getSchedule() != null).flatMap(service -> Stream.ofNullable(this.apiServicesMigration.convert((Service)service, TYPE_ENDPOINTGROUP, name))).collect(MigrationResult.collectList());
        return migratedServices.map(services -> {
            Map<String, io.gravitee.definition.model.v4.service.Service> servicesByType = services.stream().filter(service -> CONSUL_DISCOVERY_SERVICE_TYPE.equals(service.getType()) || HTTP_HEALTH_CHECK_SERVICE_TYPE.equals(service.getType())).collect(Collectors.toMap(io.gravitee.definition.model.v4.service.Service::getType, svc -> svc, (svc1, svc2) -> svc2));
            EndpointGroupServices egs = new EndpointGroupServices();
            egs.setDiscovery(servicesByType.get(CONSUL_DISCOVERY_SERVICE_TYPE));
            egs.setHealthCheck(servicesByType.get(HTTP_HEALTH_CHECK_SERVICE_TYPE));
            return egs;
        });
    }

    private MigrationResult<EndpointServices> mapEndPointServices(String configuration, String name) {
        EndpointServices endpointServices = new EndpointServices();
        MigrationResult<EndpointServices> migrationResult = MigrationResult.value(endpointServices);
        if (configuration == null) {
            return migrationResult;
        }
        try {
            MigrationResult<io.gravitee.definition.model.v4.service.Service> serviceMigrationResult;
            EndpointHealthCheckService epHealthCheckService;
            JsonNode jsonNode = this.jsonMapper.readTree(configuration);
            JsonNode hcNode = jsonNode.path("healthcheck");
            if (!(hcNode.isMissingNode() || hcNode.isNull() || (epHealthCheckService = (EndpointHealthCheckService)this.jsonMapper.treeToValue((TreeNode)hcNode, EndpointHealthCheckService.class)).getSchedule() == null || epHealthCheckService.isInherit() || (serviceMigrationResult = this.apiServicesMigration.convert((Service)epHealthCheckService, TYPE_ENDPOINT, name)) == null)) {
                return migrationResult.foldLeft(serviceMigrationResult, (endpointSvc, serviceV4) -> {
                    if (endpointSvc != null) {
                        endpointSvc.setHealthCheck(serviceV4);
                    }
                    return endpointSvc;
                });
            }
        }
        catch (JsonProcessingException e) {
            log.error("Unable to map configuration for endpoint {}", (Object)name, (Object)e);
            return migrationResult.addIssue(new MigrationResult.Issue("Unable to migrate the API, as an error occurred while parsing the healthcheck configuration for endpoint, %s. Please contact support and attach your API definition with the support ticket for debugging".formatted(name), MigrationResult.State.IMPOSSIBLE));
        }
        return migrationResult;
    }

    private @Nullable List<Property> mapProperties(@Nullable Properties properties) {
        return properties == null ? null : CollectionUtils.stream(properties.getProperties()).map(a -> new Property(a.getKey(), a.getValue(), a.isEncrypted(), a.isDynamic())).toList();
    }

    private List<io.gravitee.definition.model.v4.resource.Resource> mapResources(List<Resource> resources) {
        return CollectionUtils.stream(resources).map(this::toV4Resource).toList();
    }

    private io.gravitee.definition.model.v4.resource.Resource toV4Resource(Resource resource) {
        return new io.gravitee.definition.model.v4.resource.Resource(resource.getName(), resource.getType(), resource.getConfiguration(), resource.isEnabled());
    }

    private FlowExecution mapFlowExecution(io.gravitee.definition.model.FlowMode flowMode) {
        FlowExecution flowExecution = new FlowExecution();
        FlowMode mode = switch (flowMode) {
            default -> throw new MatchException(null, null);
            case io.gravitee.definition.model.FlowMode.DEFAULT -> FlowMode.DEFAULT;
            case io.gravitee.definition.model.FlowMode.BEST_MATCH -> FlowMode.BEST_MATCH;
        };
        flowExecution.setMode(mode);
        return flowExecution;
    }

    private LoadBalancer mapLoadBalancer(io.gravitee.definition.model.LoadBalancer lb) {
        LoadBalancerType loadBalancerType = lb.getType();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RANDOM", "ROUND_ROBIN", "WEIGHTED_RANDOM", "WEIGHTED_ROUND_ROBIN"}, (LoadBalancerType)loadBalancerType, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> new LoadBalancer(io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancerType.RANDOM);
            case 1 -> new LoadBalancer(io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancerType.ROUND_ROBIN);
            case 2 -> new LoadBalancer(io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancerType.WEIGHTED_RANDOM);
            case 3 -> new LoadBalancer(io.gravitee.definition.model.v4.endpointgroup.loadbalancer.LoadBalancerType.WEIGHTED_ROUND_ROBIN);
            case -1 -> null;
        };
    }

    private MigrationResult<io.gravitee.definition.model.v4.endpointgroup.Endpoint> mapEndpoint(Endpoint lb) {
        MigrationResult<EndpointServices> endPointServices = this.mapEndPointServices(lb.getConfiguration(), lb.getName());
        MigrationResult<String> sharedConfigurationOverride = this.mapSharedConfigurationOverride(lb.getConfiguration());
        MigrationResult<String> configuration = this.mapConfiguration(lb);
        return endPointServices.flatMap(epServices -> sharedConfigurationOverride.flatMap(sharedConfigurationOverride1 -> configuration.map(configuration1 -> ((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)io.gravitee.definition.model.v4.endpointgroup.Endpoint.builder().name(lb.getName())).type(HTTP_PROXY)).secondary(lb.isBackup())).tenants(lb.getTenants())).weight(lb.getWeight())).configuration(configuration1)).inheritConfiguration(lb.getInherit().booleanValue())).sharedConfigurationOverride(sharedConfigurationOverride1)).services(epServices).build())));
    }

    private MigrationResult<String> mapSharedConfigurationOverride(String config) {
        try {
            if (config == null) {
                return MigrationResult.value(null);
            }
            ObjectNode root = (ObjectNode)this.jsonMapper.readTree(config);
            if (root == null || root.isNull() || root.isMissingNode()) {
                return MigrationResult.value(config);
            }
            JsonNode healthcheckNode = root.path("healthcheck");
            if (healthcheckNode == null || healthcheckNode.isNull() || healthcheckNode.isMissingNode()) {
                return MigrationResult.value(config);
            }
            ArrayNode steps = root.path("healthcheck").path("steps").isArray() ? (ArrayNode)root.path("healthcheck").path("steps") : JsonNodeFactory.instance.arrayNode();
            for (JsonNode step : steps) {
                ObjectNode response = (ObjectNode)step.path("response");
                JsonNode assertionsNode = response.get("assertions");
                response.remove("assertions");
                if (assertionsNode == null || !assertionsNode.isArray() || assertionsNode.size() != 1) continue;
                response.put("assertion", StringUtils.appendCurlyBraces(assertionsNode.get(0).asText()));
            }
            return MigrationResult.value(this.jsonMapper.writeValueAsString((Object)root));
        }
        catch (JsonProcessingException e) {
            log.error("Unable to map configuration for endpoint", (Throwable)e);
            return MigrationResult.issue("Unable to migrate the API, as an error occurred while parsing the endpoint configuration. Please contact support and attach your API definition with the support ticket for debugging", MigrationResult.State.IMPOSSIBLE);
        }
    }

    private Analytics mapAnalytics(io.gravitee.definition.model.Logging v2logging) {
        boolean loggingEnabled = this.isLoggingEnabled(v2logging);
        Logging v4logging = loggingEnabled ? this.mapLogging(v2logging) : null;
        return Analytics.builder().enabled(true).logging(v4logging).build();
    }

    private boolean isLoggingEnabled(io.gravitee.definition.model.Logging v2logging) {
        if (v2logging == null) {
            return false;
        }
        return v2logging.getMode() != io.gravitee.definition.model.LoggingMode.NONE;
    }

    private Logging mapLogging(io.gravitee.definition.model.Logging v2logging) {
        return Logging.builder().condition(v2logging.getCondition()).mode(new LoggingMode(v2logging.getMode().isClientMode(), v2logging.getMode().isProxyMode())).content(new LoggingContent(v2logging.getContent().isHeaders(), false, v2logging.getContent().isPayloads(), false, false)).phase(new LoggingPhase(v2logging.getScope().isRequest(), v2logging.getScope().isResponse())).build();
    }

    private MigrationResult<String> mapConfiguration(Endpoint lb) {
        try {
            if (lb.getConfiguration() == null) {
                return MigrationResult.value(null);
            }
            JsonNode jsonNode = this.jsonMapper.readTree(lb.getConfiguration()).get("target");
            String target = jsonNode != null ? jsonNode.asText() : null;
            ObjectNode target1 = this.jsonMapper.createObjectNode().put("target", target);
            return MigrationResult.value(this.jsonMapper.writeValueAsString((Object)target1));
        }
        catch (JsonProcessingException e) {
            log.error("Unable to map configuration for endpoint {}", (Object)lb.getName(), (Object)e);
            return MigrationResult.issue("Unable to migrate the API, as an error occurred while parsing the endpoint configuration. Please contact support and attach your API definition with the support ticket for debugging", MigrationResult.State.IMPOSSIBLE);
        }
    }

    private @Nullable String addSlashIfNeeded(@Nullable String path) {
        return path == null || path.isEmpty() || path.endsWith("/") ? path : path + "/";
    }
}

