/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.audit.AuditEntity;
import io.gravitee.rest.api.model.audit.AuditQuery;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public interface AuditService {
    default public void createApiAuditLog(ExecutionContext executionContext, AuditLogData auditLogData, String apiId) {
        auditLogData.setReferenceType(Audit.AuditReferenceType.API);
        auditLogData.setReferenceId(apiId);
        this.createAuditLog(executionContext, auditLogData);
    }

    default public void createApplicationAuditLog(ExecutionContext executionContext, AuditLogData auditLogData, String applicationId) {
        auditLogData.setReferenceType(Audit.AuditReferenceType.APPLICATION);
        auditLogData.setReferenceId(applicationId);
        this.createAuditLog(executionContext, auditLogData);
    }

    default public void createEnvironmentAuditLog(ExecutionContext executionContext, AuditLogData auditLogData) {
        auditLogData.setReferenceType(Audit.AuditReferenceType.ENVIRONMENT);
        auditLogData.setReferenceId(executionContext.getEnvironmentId());
        this.createAuditLog(executionContext, auditLogData);
    }

    default public void createOrganizationAuditLog(ExecutionContext executionContext, AuditLogData auditLogData) {
        auditLogData.setReferenceType(Audit.AuditReferenceType.ORGANIZATION);
        auditLogData.setReferenceId(executionContext.getOrganizationId());
        this.createAuditLog(executionContext, auditLogData);
    }

    public void createAuditLog(ExecutionContext var1, AuditLogData var2);

    public MetadataPage<AuditEntity> search(ExecutionContext var1, AuditQuery var2);

    public static class AuditLogData {
        Audit.AuditReferenceType referenceType;
        String referenceId;
        Map<Audit.AuditProperties, String> properties;
        Audit.AuditEvent event;
        Date createdAt;
        Object oldValue;
        Object newValue;
        List<String> pathsToAnonymize;

        @Generated
        public static AuditLogDataBuilder builder() {
            return new AuditLogDataBuilder();
        }

        @Generated
        public AuditLogData(Audit.AuditReferenceType referenceType, String referenceId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue, List<String> pathsToAnonymize) {
            this.referenceType = referenceType;
            this.referenceId = referenceId;
            this.properties = properties;
            this.event = event;
            this.createdAt = createdAt;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.pathsToAnonymize = pathsToAnonymize;
        }

        @Generated
        public void setReferenceType(Audit.AuditReferenceType referenceType) {
            this.referenceType = referenceType;
        }

        @Generated
        public void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Generated
        public void setProperties(Map<Audit.AuditProperties, String> properties) {
            this.properties = properties;
        }

        @Generated
        public void setEvent(Audit.AuditEvent event) {
            this.event = event;
        }

        @Generated
        public void setCreatedAt(Date createdAt) {
            this.createdAt = createdAt;
        }

        @Generated
        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        @Generated
        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        @Generated
        public void setPathsToAnonymize(List<String> pathsToAnonymize) {
            this.pathsToAnonymize = pathsToAnonymize;
        }

        @Generated
        public Audit.AuditReferenceType getReferenceType() {
            return this.referenceType;
        }

        @Generated
        public String getReferenceId() {
            return this.referenceId;
        }

        @Generated
        public Map<Audit.AuditProperties, String> getProperties() {
            return this.properties;
        }

        @Generated
        public Audit.AuditEvent getEvent() {
            return this.event;
        }

        @Generated
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public Object getOldValue() {
            return this.oldValue;
        }

        @Generated
        public Object getNewValue() {
            return this.newValue;
        }

        @Generated
        public List<String> getPathsToAnonymize() {
            return this.pathsToAnonymize;
        }

        @Generated
        public static class AuditLogDataBuilder {
            @Generated
            private Audit.AuditReferenceType referenceType;
            @Generated
            private String referenceId;
            @Generated
            private Map<Audit.AuditProperties, String> properties;
            @Generated
            private Audit.AuditEvent event;
            @Generated
            private Date createdAt;
            @Generated
            private Object oldValue;
            @Generated
            private Object newValue;
            @Generated
            private List<String> pathsToAnonymize;

            @Generated
            AuditLogDataBuilder() {
            }

            @Generated
            public AuditLogDataBuilder referenceType(Audit.AuditReferenceType referenceType) {
                this.referenceType = referenceType;
                return this;
            }

            @Generated
            public AuditLogDataBuilder referenceId(String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            @Generated
            public AuditLogDataBuilder properties(Map<Audit.AuditProperties, String> properties) {
                this.properties = properties;
                return this;
            }

            @Generated
            public AuditLogDataBuilder event(Audit.AuditEvent event) {
                this.event = event;
                return this;
            }

            @Generated
            public AuditLogDataBuilder createdAt(Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Generated
            public AuditLogDataBuilder oldValue(Object oldValue) {
                this.oldValue = oldValue;
                return this;
            }

            @Generated
            public AuditLogDataBuilder newValue(Object newValue) {
                this.newValue = newValue;
                return this;
            }

            @Generated
            public AuditLogDataBuilder pathsToAnonymize(List<String> pathsToAnonymize) {
                this.pathsToAnonymize = pathsToAnonymize;
                return this;
            }

            @Generated
            public AuditLogData build() {
                return new AuditLogData(this.referenceType, this.referenceId, this.properties, this.event, this.createdAt, this.oldValue, this.newValue, this.pathsToAnonymize);
            }

            @Generated
            public String toString() {
                return "AuditService.AuditLogData.AuditLogDataBuilder(referenceType=" + String.valueOf(this.referenceType) + ", referenceId=" + this.referenceId + ", properties=" + String.valueOf(this.properties) + ", event=" + String.valueOf(this.event) + ", createdAt=" + String.valueOf(this.createdAt) + ", oldValue=" + String.valueOf(this.oldValue) + ", newValue=" + String.valueOf(this.newValue) + ", pathsToAnonymize=" + String.valueOf(this.pathsToAnonymize) + ")";
            }
        }
    }
}

