/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.ApiServicesCRD;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.api.model.property.EncryptableProperty;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.ApiCRDAdapter;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.nativeapi.NativeAnalytics;
import io.gravitee.definition.model.v4.nativeapi.NativeApiServices;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.ApiServices;
import io.gravitee.rest.api.model.AccessControlEntity;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiCRDAdapterImpl
implements ApiCRDAdapter {
    @Override
    public ApiCRDSpec toCRDSpec(ExportApiEntity exportEntity, ApiEntity apiEntity) {
        if (exportEntity == null && apiEntity == null) {
            return null;
        }
        ApiCRDSpec.ApiCRDSpecBuilder apiCRDSpec = ApiCRDSpec.builder();
        if (exportEntity != null) {
            apiCRDSpec.metadata(this.apiMetadataEntitySetToApiMetadataList(exportEntity.getMetadata()));
        }
        if (apiEntity != null) {
            List list6;
            List list3;
            List list2;
            List list1;
            Set set;
            Map map;
            apiCRDSpec.version(apiEntity.getApiVersion());
            apiCRDSpec.id(apiEntity.getId());
            apiCRDSpec.crossId(apiEntity.getCrossId());
            apiCRDSpec.hrid(apiEntity.getHrid());
            apiCRDSpec.name(apiEntity.getName());
            apiCRDSpec.description(apiEntity.getDescription());
            if (apiEntity.getType() != null) {
                apiCRDSpec.type(apiEntity.getType().name());
            }
            if (apiEntity.getState() != null) {
                apiCRDSpec.state(apiEntity.getState().name());
            }
            if (apiEntity.getLifecycleState() != null) {
                apiCRDSpec.lifecycleState(apiEntity.getLifecycleState().name());
            }
            if (apiEntity.getVisibility() != null) {
                apiCRDSpec.visibility(apiEntity.getVisibility().name());
            }
            if ((map = apiEntity.getResponseTemplates()) != null) {
                apiCRDSpec.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
            }
            if ((set = apiEntity.getTags()) != null) {
                apiCRDSpec.tags(new LinkedHashSet<String>(set));
            }
            if ((list1 = apiEntity.getLabels()) != null) {
                apiCRDSpec.labels(new LinkedHashSet<String>(list1));
            }
            if ((list2 = apiEntity.getResources()) != null) {
                apiCRDSpec.resources(new ArrayList<Resource>(list2));
            }
            if ((list3 = apiEntity.getFlows()) != null) {
                apiCRDSpec.flows(new ArrayList(list3));
            }
            apiCRDSpec.properties(this.propertyListToEncryptablePropertyList(apiEntity.getProperties()));
            List list5 = apiEntity.getListeners();
            if (list5 != null) {
                apiCRDSpec.listeners(new ArrayList(list5));
            }
            if ((list6 = apiEntity.getEndpointGroups()) != null) {
                apiCRDSpec.endpointGroups(new ArrayList(list6));
            }
            apiCRDSpec.analytics(apiEntity.getAnalytics());
            apiCRDSpec.failover(apiEntity.getFailover());
            Set set1 = apiEntity.getGroups();
            if (set1 != null) {
                apiCRDSpec.groups(new LinkedHashSet<String>(set1));
            }
            apiCRDSpec.flowExecution(apiEntity.getFlowExecution());
            Set set2 = apiEntity.getCategories();
            if (set2 != null) {
                apiCRDSpec.categories(new LinkedHashSet<String>(set2));
            }
            apiCRDSpec.services(this.apiServicesToApiServicesCRD(apiEntity.getServices()));
        }
        apiCRDSpec.plans(this.mapPlans(exportEntity));
        apiCRDSpec.pages(this.mapPages(exportEntity));
        apiCRDSpec.members(this.mapMembers(exportEntity));
        apiCRDSpec.notifyMembers(!exportEntity.getApiEntity().isDisableMembershipNotifications());
        return apiCRDSpec.build();
    }

    @Override
    public ApiCRDSpec toCRDSpec(ExportApiEntity exportEntity, NativeApiEntity apiEntity) {
        if (exportEntity == null && apiEntity == null) {
            return null;
        }
        ApiCRDSpec.ApiCRDSpecBuilder apiCRDSpec = ApiCRDSpec.builder();
        if (exportEntity != null) {
            apiCRDSpec.metadata(this.apiMetadataEntitySetToApiMetadataList(exportEntity.getMetadata()));
        }
        if (apiEntity != null) {
            Set set2;
            List list6;
            List list3;
            List list2;
            List list1;
            Set set;
            apiCRDSpec.version(apiEntity.getApiVersion());
            apiCRDSpec.id(apiEntity.getId());
            apiCRDSpec.crossId(apiEntity.getCrossId());
            apiCRDSpec.hrid(apiEntity.getHrid());
            apiCRDSpec.name(apiEntity.getName());
            apiCRDSpec.description(apiEntity.getDescription());
            if (apiEntity.getType() != null) {
                apiCRDSpec.type(apiEntity.getType().name());
            }
            if (apiEntity.getState() != null) {
                apiCRDSpec.state(apiEntity.getState().name());
            }
            if (apiEntity.getLifecycleState() != null) {
                apiCRDSpec.lifecycleState(apiEntity.getLifecycleState().name());
            }
            if (apiEntity.getVisibility() != null) {
                apiCRDSpec.visibility(apiEntity.getVisibility().name());
            }
            if ((set = apiEntity.getTags()) != null) {
                apiCRDSpec.tags(new LinkedHashSet<String>(set));
            }
            if ((list1 = apiEntity.getLabels()) != null) {
                apiCRDSpec.labels(new LinkedHashSet<String>(list1));
            }
            if ((list2 = apiEntity.getResources()) != null) {
                apiCRDSpec.resources(new ArrayList<Resource>(list2));
            }
            if ((list3 = apiEntity.getFlows()) != null) {
                apiCRDSpec.flows(new ArrayList(list3));
            }
            apiCRDSpec.properties(this.propertyListToEncryptablePropertyList(apiEntity.getProperties()));
            List list5 = apiEntity.getListeners();
            if (list5 != null) {
                apiCRDSpec.listeners(new ArrayList(list5));
            }
            if ((list6 = apiEntity.getEndpointGroups()) != null) {
                apiCRDSpec.endpointGroups(new ArrayList(list6));
            }
            apiCRDSpec.analytics(this.nativeAnalyticsToAnalytics(apiEntity.getAnalytics()));
            Set set1 = apiEntity.getGroups();
            if (set1 != null) {
                apiCRDSpec.groups(new LinkedHashSet<String>(set1));
            }
            if ((set2 = apiEntity.getCategories()) != null) {
                apiCRDSpec.categories(new LinkedHashSet<String>(set2));
            }
            apiCRDSpec.services(this.nativeApiServicesToApiServicesCRD(apiEntity.getServices()));
        }
        apiCRDSpec.plans(this.mapPlans(exportEntity));
        apiCRDSpec.pages(this.mapPages(exportEntity));
        apiCRDSpec.members(this.mapMembers(exportEntity));
        apiCRDSpec.notifyMembers(!exportEntity.getApiEntity().isDisableMembershipNotifications());
        return apiCRDSpec.build();
    }

    @Override
    public PlanCRD toCRDPlan(PlanEntity planEntity) {
        List list1;
        if (planEntity == null) {
            return null;
        }
        PlanCRD.PlanCRDBuilder planCRD = PlanCRD.builder();
        planCRD.id(planEntity.getId());
        planCRD.crossId(planEntity.getCrossId());
        planCRD.hrid(planEntity.getHrid());
        planCRD.name(planEntity.getName());
        planCRD.description(planEntity.getDescription());
        planCRD.security(planEntity.getSecurity());
        List list = planEntity.getCharacteristics();
        if (list != null) {
            planCRD.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = planEntity.getExcludedGroups()) != null) {
            planCRD.excludedGroups(new ArrayList<String>(list1));
        }
        planCRD.generalConditions(planEntity.getGeneralConditions());
        planCRD.generalConditionsHrid(planEntity.getGeneralConditionsHrid());
        planCRD.order(planEntity.getOrder());
        planCRD.selectionRule(planEntity.getSelectionRule());
        planCRD.status(planEntity.getStatus());
        Set set = planEntity.getTags();
        if (set != null) {
            planCRD.tags(new LinkedHashSet<String>(set));
        }
        planCRD.type(this.planTypeToPlanType(planEntity.getType()));
        planCRD.validation(this.planValidationTypeToPlanValidationType(planEntity.getValidation()));
        List list2 = planEntity.getFlows();
        if (list2 != null) {
            planCRD.flows(new ArrayList(list2));
        }
        planCRD.mode(planEntity.getMode());
        return planCRD.build();
    }

    @Override
    public PlanCRD toCRDPlan(NativePlanEntity planEntity) {
        List list1;
        if (planEntity == null) {
            return null;
        }
        PlanCRD.PlanCRDBuilder planCRD = PlanCRD.builder();
        planCRD.id(planEntity.getId());
        planCRD.crossId(planEntity.getCrossId());
        planCRD.hrid(planEntity.getHrid());
        planCRD.name(planEntity.getName());
        planCRD.description(planEntity.getDescription());
        planCRD.security(planEntity.getSecurity());
        List list = planEntity.getCharacteristics();
        if (list != null) {
            planCRD.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = planEntity.getExcludedGroups()) != null) {
            planCRD.excludedGroups(new ArrayList<String>(list1));
        }
        planCRD.generalConditions(planEntity.getGeneralConditions());
        planCRD.generalConditionsHrid(planEntity.getGeneralConditionsHrid());
        planCRD.order(planEntity.getOrder());
        planCRD.selectionRule(planEntity.getSelectionRule());
        planCRD.status(planEntity.getStatus());
        Set set = planEntity.getTags();
        if (set != null) {
            planCRD.tags(new LinkedHashSet<String>(set));
        }
        planCRD.type(this.planTypeToPlanType(planEntity.getType()));
        planCRD.validation(this.planValidationTypeToPlanValidationType(planEntity.getValidation()));
        List list2 = planEntity.getFlows();
        if (list2 != null) {
            planCRD.flows(new ArrayList(list2));
        }
        planCRD.mode(planEntity.getMode());
        return planCRD.build();
    }

    @Override
    public PageCRD toCRDPage(PageEntity pageEntity) {
        if (pageEntity == null) {
            return null;
        }
        PageCRD.PageCRDBuilder pageCRD = PageCRD.builder();
        pageCRD.source(this.pageSourceEntityToPageSource(pageEntity.getSource()));
        pageCRD.id(pageEntity.getId());
        pageCRD.hrid(pageEntity.getHrid());
        pageCRD.crossId(pageEntity.getCrossId());
        pageCRD.name(pageEntity.getName());
        if (pageEntity.getType() != null) {
            pageCRD.type(Enum.valueOf(PageCRD.Type.class, pageEntity.getType()));
        }
        pageCRD.order(pageEntity.getOrder());
        pageCRD.published(pageEntity.isPublished());
        pageCRD.visibility(this.visibilityToVisibility(pageEntity.getVisibility()));
        pageCRD.parentId(pageEntity.getParentId());
        Map map = pageEntity.getConfiguration();
        if (map != null) {
            pageCRD.configuration(new LinkedHashMap<String, String>(map));
        }
        pageCRD.accessControls(this.accessControlEntitySetToAccessControlSet(pageEntity.getAccessControls()));
        pageCRD.excludedAccessControls(pageEntity.isExcludedAccessControls());
        pageCRD.content(pageEntity.getContent());
        pageCRD.homepage(pageEntity.isHomepage());
        return pageCRD.build();
    }

    protected Metadata.MetadataFormat metadataFormatToMetadataFormat(MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case MetadataFormat.STRING -> Metadata.MetadataFormat.STRING;
            case MetadataFormat.NUMERIC -> Metadata.MetadataFormat.NUMERIC;
            case MetadataFormat.BOOLEAN -> Metadata.MetadataFormat.BOOLEAN;
            case MetadataFormat.DATE -> Metadata.MetadataFormat.DATE;
            case MetadataFormat.MAIL -> Metadata.MetadataFormat.MAIL;
            case MetadataFormat.URL -> Metadata.MetadataFormat.URL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(metadataFormat));
        };
    }

    protected ApiMetadata apiMetadataEntityToApiMetadata(ApiMetadataEntity apiMetadataEntity) {
        if (apiMetadataEntity == null) {
            return null;
        }
        ApiMetadata.ApiMetadataBuilder apiMetadata = ApiMetadata.builder();
        apiMetadata.apiId(apiMetadataEntity.getApiId());
        apiMetadata.key(apiMetadataEntity.getKey());
        apiMetadata.name(apiMetadataEntity.getName());
        apiMetadata.format(this.metadataFormatToMetadataFormat(apiMetadataEntity.getFormat()));
        apiMetadata.value(apiMetadataEntity.getValue());
        apiMetadata.defaultValue(apiMetadataEntity.getDefaultValue());
        return apiMetadata.build();
    }

    protected List<ApiMetadata> apiMetadataEntitySetToApiMetadataList(Set<ApiMetadataEntity> set) {
        if (set == null) {
            return null;
        }
        ArrayList<ApiMetadata> list = new ArrayList<ApiMetadata>(set.size());
        for (ApiMetadataEntity apiMetadataEntity : set) {
            list.add(this.apiMetadataEntityToApiMetadata(apiMetadataEntity));
        }
        return list;
    }

    protected EncryptableProperty propertyToEncryptableProperty(Property property) {
        if (property == null) {
            return null;
        }
        EncryptableProperty.EncryptablePropertyBuilder encryptableProperty = EncryptableProperty.builder();
        encryptableProperty.key(property.getKey());
        encryptableProperty.value(property.getValue());
        encryptableProperty.encrypted(property.isEncrypted());
        encryptableProperty.dynamic(property.isDynamic());
        return encryptableProperty.build();
    }

    protected List<EncryptableProperty> propertyListToEncryptablePropertyList(List<Property> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EncryptableProperty> list1 = new ArrayList<EncryptableProperty>(list.size());
        for (Property property : list) {
            list1.add(this.propertyToEncryptableProperty(property));
        }
        return list1;
    }

    protected ApiServicesCRD apiServicesToApiServicesCRD(ApiServices apiServices) {
        if (apiServices == null) {
            return null;
        }
        ApiServicesCRD apiServicesCRD = new ApiServicesCRD();
        apiServicesCRD.setDynamicProperty(apiServices.getDynamicProperty());
        return apiServicesCRD;
    }

    protected Analytics nativeAnalyticsToAnalytics(NativeAnalytics nativeAnalytics) {
        if (nativeAnalytics == null) {
            return null;
        }
        Analytics.AnalyticsBuilder analytics = Analytics.builder();
        analytics.enabled(nativeAnalytics.isEnabled());
        return analytics.build();
    }

    protected ApiServicesCRD nativeApiServicesToApiServicesCRD(NativeApiServices nativeApiServices) {
        if (nativeApiServices == null) {
            return null;
        }
        ApiServicesCRD apiServicesCRD = new ApiServicesCRD();
        apiServicesCRD.setDynamicProperty(nativeApiServices.getDynamicProperty());
        return apiServicesCRD;
    }

    protected Plan.PlanType planTypeToPlanType(PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case PlanType.API -> Plan.PlanType.API;
            case PlanType.CATALOG -> Plan.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(planType));
        };
    }

    protected Plan.PlanValidationType planValidationTypeToPlanValidationType(PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case PlanValidationType.AUTO -> Plan.PlanValidationType.AUTO;
            case PlanValidationType.MANUAL -> Plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(planValidationType));
        };
    }

    protected PageCRD.PageSource pageSourceEntityToPageSource(PageSourceEntity pageSourceEntity) {
        if (pageSourceEntity == null) {
            return null;
        }
        PageCRD.PageSource.PageSourceBuilder pageSource = PageCRD.PageSource.builder();
        pageSource.configurationMap(this.deserializeConfig(pageSourceEntity.getConfiguration()));
        pageSource.type(pageSourceEntity.getType());
        pageSource.configuration(pageSourceEntity.getConfiguration());
        return pageSource.build();
    }

    protected PageCRD.Visibility visibilityToVisibility(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> PageCRD.Visibility.PUBLIC;
            case Visibility.PRIVATE -> PageCRD.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(visibility));
        };
    }

    protected AccessControl accessControlEntityToAccessControl(AccessControlEntity accessControlEntity) {
        if (accessControlEntity == null) {
            return null;
        }
        AccessControl.AccessControlBuilder accessControl = AccessControl.builder();
        accessControl.referenceId(accessControlEntity.getReferenceId());
        accessControl.referenceType(accessControlEntity.getReferenceType());
        return accessControl.build();
    }

    protected Set<AccessControl> accessControlEntitySetToAccessControlSet(Set<AccessControlEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<AccessControl> set1 = LinkedHashSet.newLinkedHashSet(set.size());
        for (AccessControlEntity accessControlEntity : set) {
            set1.add(this.accessControlEntityToAccessControl(accessControlEntity));
        }
        return set1;
    }
}

