/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.v4.analytics.TopHitsApis;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentTopHitsApisCountUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentTopHitsApisCountUseCase.class);
    AnalyticsQueryService analyticsQueryService;
    ApiQueryService apiQueryService;

    public Output execute(Input input) {
        String envId = input.executionContext().getEnvironmentId();
        Map<String, Api> apis = this.getAllApisForEnv(envId);
        List<String> apiIds = apis.keySet().stream().toList();
        log.debug("Searching top API hits, found: {} APIs for env: {}", (Object)apiIds.size(), (Object)envId);
        return this.analyticsQueryService.searchTopHitsApis(input.executionContext(), input.parameters().withApiIds(apiIds)).map(topHitsApis -> this.sortByCountAndUpdateTopHitsWithApiNames(apis, (TopHitsApis)topHitsApis)).map(Output::new).orElse(new Output(TopHitsApis.builder().data(List.of()).build()));
    }

    private Map<String, Api> getAllApisForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(List.of(DefinitionVersion.V4, DefinitionVersion.V2)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.toMap(Api::getId, value -> value));
    }

    private TopHitsApis sortByCountAndUpdateTopHitsWithApiNames(Map<String, Api> apis, TopHitsApis topHitsApis) {
        List<TopHitsApis.TopHitApi> data = topHitsApis.getData().stream().sorted(Comparator.comparingLong(TopHitsApis.TopHitApi::count).reversed()).map(topHitApi -> {
            Api api = (Api)apis.get(topHitApi.id());
            return TopHitsApis.TopHitApi.builder().id(topHitApi.id()).name(api.getName()).count(topHitApi.count()).definitionVersion(Optional.ofNullable(api.getDefinitionVersion()).orElse(DefinitionVersion.V2)).build();
        }).toList();
        return TopHitsApis.builder().data(data).build();
    }

    @Generated
    public SearchEnvironmentTopHitsApisCountUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ExecutionContext executionContext;
            @Generated
            private AnalyticsQueryParameters parameters;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public InputBuilder parameters(AnalyticsQueryParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.executionContext, this.parameters);
            }

            @Generated
            public String toString() {
                return "SearchEnvironmentTopHitsApisCountUseCase.Input.InputBuilder(executionContext=" + String.valueOf(this.executionContext) + ", parameters=" + String.valueOf(this.parameters) + ")";
            }
        }
    }

    public record Output(TopHitsApis topHitsApis) {
    }
}

