/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.policy;

import io.gravitee.apim.core.plugin.model.FlowPhase;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.policy.exception.UnexpectedPoliciesException;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.model.v4.policy.ApiProtocolType;
import io.gravitee.rest.api.model.v4.policy.PolicyPluginEntity;
import io.gravitee.rest.api.service.v4.PolicyPluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PolicyValidationDomainServiceLegacyWrapper
implements PolicyValidationDomainService {
    private final PolicyPluginService policyPluginService;

    @Override
    public String validateAndSanitizeConfiguration(String policyName, String configuration) {
        return this.policyPluginService.validatePolicyConfiguration(policyName, configuration);
    }

    @Override
    public void validatePoliciesFlowPhase(List<String> policyIds, ApiType apiType, FlowPhase phase) throws UnexpectedPoliciesException {
        Map policiesMap = this.policyPluginService.findAll().stream().collect(Collectors.toMap(PlatformPluginEntity::getId, Function.identity()));
        ArrayList<String> policyNamesUnexpected = new ArrayList<String>();
        policyIds.forEach(policyId -> {
            if (policiesMap.containsKey(policyId)) {
                PolicyPluginEntity policy = (PolicyPluginEntity)policiesMap.get(policyId);
                if (apiType.equals((Object)ApiType.PROXY) && (policy.getFlowPhaseCompatibility(ApiProtocolType.HTTP_PROXY) == null || policy.getFlowPhaseCompatibility(ApiProtocolType.HTTP_PROXY).stream().noneMatch(p -> p.name().equals(phase.name())))) {
                    policyNamesUnexpected.add(policy.getName());
                }
                if (apiType.equals((Object)ApiType.MESSAGE) && (policy.getFlowPhaseCompatibility(ApiProtocolType.HTTP_MESSAGE) == null || policy.getFlowPhaseCompatibility(ApiProtocolType.HTTP_MESSAGE).stream().noneMatch(p -> p.name().equals(phase.name())))) {
                    policyNamesUnexpected.add(policy.getName());
                }
            }
        });
        if (!policyNamesUnexpected.isEmpty()) {
            throw new UnexpectedPoliciesException(policyNamesUnexpected, apiType.name(), phase.name());
        }
    }

    @Generated
    public PolicyValidationDomainServiceLegacyWrapper(PolicyPluginService policyPluginService) {
        this.policyPluginService = policyPluginService;
    }
}

