/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.integration;

import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IntegrationCrudServiceImpl
extends AbstractService
implements IntegrationCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationCrudServiceImpl.class);
    private final IntegrationRepository integrationRepository;

    public IntegrationCrudServiceImpl(@Lazy IntegrationRepository integrationRepository) {
        this.integrationRepository = integrationRepository;
    }

    @Override
    public <T extends Integration> T create(T integration) {
        try {
            IntegrationAdapter.SpecificAdapter<T> specificAdapter = IntegrationAdapter.INSTANCE.specific(integration);
            io.gravitee.repository.management.model.Integration createdIntegration = this.integrationRepository.create(specificAdapter.toRepository(integration));
            return specificAdapter.toEntity(createdIntegration);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating Integration: " + integration.name(), e);
        }
    }

    @Override
    public Optional<Integration.ApiIntegration> findApiIntegrationById(String id) {
        return this.findById(id, IntegrationAdapter.SPECIFIC_API_INTEGRATION_ADAPTER::toEntity);
    }

    @Override
    public Optional<Integration.A2aIntegration> findA2aIntegrationById(String id) {
        return this.findById(id, IntegrationAdapter.SPECIFIC_A2A_INTEGRATION_ADAPTER::toEntity);
    }

    @Override
    public Optional<Integration> findById(String id) {
        return this.findById(id, IntegrationAdapter.INSTANCE::toEntity);
    }

    public <T extends Integration> Optional<T> findById(String id, Function<io.gravitee.repository.management.model.Integration, T> mapper) {
        try {
            return this.integrationRepository.findByIntegrationId(id).map(mapper);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find the integration: " + id, e);
        }
    }

    @Override
    public <T extends Integration> T update(T integration) {
        try {
            IntegrationAdapter.SpecificAdapter<T> specificAdapter = IntegrationAdapter.INSTANCE.specific(integration);
            io.gravitee.repository.management.model.Integration updatedIntegration = this.integrationRepository.update(specificAdapter.toRepository(integration));
            return specificAdapter.toEntity(updatedIntegration);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred when updating integration: " + integration.id(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.integrationRepository.delete(id);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Integration: " + id, e);
        }
    }
}

