/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.mapper.V2toV4MigrationOperator;
import io.gravitee.apim.core.api.model.utils.MigrationResult;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.v4.flow.Flow;
import jakarta.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class MigrateApiUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrateApiUseCase.class);
    private final ApiCrudService apiCrudService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final PlanCrudService planService;
    private final FlowCrudService flowCrudService;
    private final ApiStateDomainService apiStateService;
    private final V2toV4MigrationOperator migrationOperator;
    private final PageQueryService pageQueryService;

    @Inject
    public MigrateApiUseCase(ApiCrudService apiCrudService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, PlanCrudService planService, FlowCrudService flowCrudService, ApiStateDomainService apiStateService, JsonMapper jsonMapper, PageQueryService pageQueryService) {
        this.apiCrudService = apiCrudService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.planService = planService;
        this.flowCrudService = flowCrudService;
        this.apiStateService = apiStateService;
        this.migrationOperator = new V2toV4MigrationOperator(jsonMapper);
        this.pageQueryService = pageQueryService;
    }

    public Output execute(Input input) {
        Api api = this.apiCrudService.findById(input.apiId()).orElseThrow(() -> new ApiNotFoundException(input.apiId()));
        if (api.getDefinitionVersion() != DefinitionVersion.V2) {
            return new Output(input.apiId(), List.of(new MigrationResult.Issue("Unable to migrate an API which is not a v2 definition. Please ensure the API is of type V2 before migration", MigrationResult.State.IMPOSSIBLE)));
        }
        MigrationResult<?> precondition = this.chekPreconditions(input, api);
        List<Page> pageEntities = this.pageQueryService.searchByApiId(input.apiId());
        precondition = precondition.addIssues(this.checkPages(pageEntities));
        MigrationResult<Migration> migrationResult = precondition.flatMap(ignored -> this.migrationOperator.mapApi(api)).map(Migration::new);
        Collection<Plan> plans = this.planService.findByApiId(input.apiId());
        for (Plan plan : plans) {
            MigrationResult<Plan> migratedPlan = this.migrationOperator.mapPlan(plan);
            migrationResult = migrationResult.foldLeft(migratedPlan, Migration::withPlan);
        }
        List<io.gravitee.definition.model.flow.Flow> apiV2Flows = this.flowCrudService.getApiV2Flows(input.apiId());
        MigrationResult<Migration.ReferencedFlow> result = this.migrationOperator.mapFlows(apiV2Flows).map(flows -> new Migration.ReferencedFlow.Api(input.apiId(), (List<Flow>)flows));
        migrationResult = migrationResult.foldLeft(result, Migration::withFlow);
        for (String planId : CollectionUtils.stream(plans).map(Plan::getId).toList()) {
            List<io.gravitee.definition.model.flow.Flow> planV2Flows = this.flowCrudService.getPlanV2Flows(planId);
            result = this.migrationOperator.mapFlows(planV2Flows).map(flows -> new Migration.ReferencedFlow.Plan(planId, (List<Flow>)flows));
            migrationResult = migrationResult.foldLeft(result, Migration::withFlow);
        }
        MigrationResult.State state = this.applyMigration(migrationResult, input.mode(), migration -> this.storeMigration(input, (Migration)migration, api));
        return new Output(input.apiId(), migrationResult.issues(), state);
    }

    private MigrationResult<?> chekPreconditions(Input input, Api api) {
        MigrationResult<Integer> precondition = MigrationResult.value(1);
        if (!this.apiStateService.isSynchronized(api, input.auditInfo())) {
            precondition = precondition.addIssue("This API is out of sync. Please deploy your API before migration to ensure a smooth transition", MigrationResult.State.CAN_BE_FORCED);
        }
        if (api.getApiDefinition().getExecutionMode() == ExecutionMode.V3) {
            precondition = precondition.addIssue("Only APIs with the \u201cV4 Emulation Engine\u201d enabled can be deployed. Please enable the V4 Emulation Engine before migrating your API", MigrationResult.State.IMPOSSIBLE);
        }
        return precondition;
    }

    private <T> MigrationResult.State applyMigration(MigrationResult<T> result, Input.UpgradeMode mode, Consumer<T> consumer) {
        MigrationResult.State acceptableLimit;
        if (mode == Input.UpgradeMode.DRY_RUN) {
            return result.state();
        }
        MigrationResult.State state = acceptableLimit = mode == Input.UpgradeMode.FORCE ? MigrationResult.State.CAN_BE_FORCED : MigrationResult.State.MIGRATABLE;
        if (result.state().getWeight() <= acceptableLimit.getWeight()) {
            result.processValue(consumer);
            return MigrationResult.State.MIGRATED;
        }
        return result.state();
    }

    private Collection<MigrationResult.Issue> checkPages(List<Page> pageEntities) {
        Map pagesById = pageEntities.stream().collect(Collectors.toMap(Page::getId, Function.identity()));
        ArrayList<MigrationResult.Issue> issues = new ArrayList<MigrationResult.Issue>();
        for (Page page : pageEntities) {
            if (page.getType() == Page.Type.TRANSLATION) {
                String pageName = ((Page)pagesById.get(page.getParentId())).getName();
                issues.add(new MigrationResult.Issue("Unable to migrate the API as it has document %s, with translations. Please ensure your API does not have documents with translations".formatted(pageName), MigrationResult.State.IMPOSSIBLE));
            }
            if (CollectionUtils.isNotEmpty(page.getAccessControls())) {
                issues.add(new MigrationResult.Issue("Unable to migrate the API as it has document %s, with Access Control. Please ensure your API does not have documents with Access Control".formatted(page.getName()), MigrationResult.State.IMPOSSIBLE));
            }
            if (!CollectionUtils.isNotEmpty(page.getAttachedMedia())) continue;
            issues.add(new MigrationResult.Issue("Unable to migrate the API as it has document %s, with Attached Resources. Please ensure your API does not have documents with attached resources".formatted(page.getName()), MigrationResult.State.IMPOSSIBLE));
        }
        return issues;
    }

    private void storeMigration(Input input, Migration migration, Api api) {
        if (migration.api().getApiDefinitionHttpV4().getServices() != null && migration.api().getApiDefinitionHttpV4().getServices().getDynamicProperty() != null && migration.api().getApiDefinitionHttpV4().getServices().getDynamicProperty().isEnabled()) {
            this.apiStateService.stopV2DynamicProperties(input.apiId());
        }
        Api upgraded = this.apiCrudService.update(migration.api());
        if (migration.api().getApiDefinitionHttpV4().getServices() != null && migration.api().getApiDefinitionHttpV4().getServices().getDynamicProperty() != null && migration.api().getApiDefinitionHttpV4().getServices().getDynamicProperty().isEnabled()) {
            this.apiStateService.startV4DynamicProperties(input.apiId());
        }
        PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(input.auditInfo().organizationId(), input.apiId());
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().event(ApiAuditEvent.API_UPDATED).actor(AuditActor.builder().userId(input.auditInfo().actor().userId()).build()).apiId(input.apiId()).environmentId(input.auditInfo().environmentId()).organizationId(input.auditInfo().organizationId()).createdAt(TimeProvider.now()).oldValue(api).newValue(upgraded).properties(Map.of(AuditProperties.API, input.apiId())).build());
        ApiIndexerDomainService.Context indexerContext = new ApiIndexerDomainService.Context(input.auditInfo(), false);
        this.apiIndexerDomainService.delete(indexerContext, api);
        this.apiIndexerDomainService.index(indexerContext, upgraded, apiPrimaryOwner);
        migration.plans().forEach(this.planService::update);
        block4: for (Migration.ReferencedFlow a : migration.flows()) {
            Migration.ReferencedFlow referencedFlow;
            Objects.requireNonNull(a);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Migration.ReferencedFlow.Plan.class, Migration.ReferencedFlow.Api.class}, (Object)referencedFlow, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Migration.ReferencedFlow.Plan planFlows = (Migration.ReferencedFlow.Plan)referencedFlow;
                    this.flowCrudService.savePlanFlows(planFlows.id(), planFlows.flows());
                    continue block4;
                }
                case 1: 
            }
            Migration.ReferencedFlow.Api apiFlows = (Migration.ReferencedFlow.Api)referencedFlow;
            this.flowCrudService.saveApiFlows(apiFlows.id(), apiFlows.flows());
        }
    }

    public record Input(String apiId, UpgradeMode mode, AuditInfo auditInfo) {

        public static enum UpgradeMode {
            DRY_RUN,
            FORCE;

        }
    }

    public record Output(String apiId, Collection<MigrationResult.Issue> issues, MigrationResult.State state) {
        private static final Comparator<MigrationResult.State> STATE_COMPARATOR = Comparator.comparing(MigrationResult.State::getWeight);

        public Output(String apiId, Collection<MigrationResult.Issue> issues) {
            this(apiId, issues, CollectionUtils.stream(issues).map(MigrationResult.Issue::state).max(STATE_COMPARATOR).orElse(MigrationResult.State.MIGRATABLE));
        }
    }

    private record Migration(Api api, Collection<Plan> plans, Collection<ReferencedFlow> flows) {
        public Migration(Api api) {
            this(api, List.of(), List.of());
        }

        public static @Nullable Migration withPlan(@Nullable Migration migration, Plan plan) {
            return migration == null ? null : new Migration(migration.api, Stream.concat(migration.plans.stream(), Stream.of(plan)).toList(), migration.flows);
        }

        public static @Nullable Migration withFlow(@Nullable Migration migration, ReferencedFlow flow) {
            return migration == null ? null : new Migration(migration.api, migration.plans, Stream.concat(migration.flows.stream(), Stream.of(flow)).toList());
        }

        public static sealed interface ReferencedFlow {
            public String id();

            public List<Flow> flows();

            public record Plan(String id, List<Flow> flows) implements ReferencedFlow
            {
            }

            public record Api(String id, List<Flow> flows) implements ReferencedFlow
            {
            }
        }
    }
}

