/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.node.api.Node;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandQuery;
import io.gravitee.rest.api.model.command.NewCommandEntity;
import io.gravitee.rest.api.service.CommandService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.converter.CommandConverter;
import io.gravitee.rest.api.service.exceptions.Message2RecipientNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CommandServiceImpl
extends AbstractService
implements CommandService {
    private final Logger logger = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Lazy
    @Autowired
    CommandRepository commandRepository;
    @Autowired
    CommandConverter commandConverter;
    @Autowired
    Node node;

    @Override
    public void send(ExecutionContext executionContext, NewCommandEntity commandEntity) {
        if (commandEntity.getTo() == null || commandEntity.getTo().isEmpty()) {
            throw new Message2RecipientNotFoundException();
        }
        Command command = this.commandConverter.toCommand(executionContext, commandEntity);
        try {
            this.commandRepository.create((Object)command);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create {}", (Object)command, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + String.valueOf(command), ex);
        }
    }

    @Override
    public List<CommandEntity> search(CommandQuery query) {
        return this.search(null, query);
    }

    @Override
    public List<CommandEntity> search(ExecutionContext executionContext, CommandQuery query) {
        String[] tags = null;
        if (query.getTags() != null) {
            tags = (String[])query.getTags().stream().map(Enum::name).toArray(String[]::new);
        }
        CommandCriteria.Builder criteriaBuilder = new CommandCriteria.Builder().to(query.getTo()).tags(tags);
        if (executionContext != null) {
            criteriaBuilder.organizationId(executionContext.getOrganizationId()).environmentId(executionContext.hasEnvironmentId() ? executionContext.getEnvironmentId() : null);
        }
        CommandCriteria criteria = criteriaBuilder.notAckBy(query.getNotAckBy()).build();
        return this.commandRepository.search(criteria).stream().map(this.commandConverter::toCommandEntity).collect(Collectors.toList());
    }

    @Override
    public void ack(String messageId) {
        try {
            Optional optMsg = this.commandRepository.findById((Object)messageId);
            if (optMsg.isPresent()) {
                Command msg = (Command)optMsg.get();
                if (msg.getAcknowledgments() == null) {
                    msg.setAcknowledgments(Collections.singletonList(this.node.id()));
                } else if (!msg.getAcknowledgments().contains(this.node.id())) {
                    msg.getAcknowledgments().add(this.node.id());
                }
                this.commandRepository.update((Object)msg);
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to acknowledge a message", (Throwable)ex);
        }
    }

    @Override
    public void delete(String commandId) {
        try {
            this.commandRepository.delete((Object)commandId);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete command " + commandId;
            this.logger.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }
}

