/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.service.CategoryService;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="Console")
public class CategoryMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CategoryMapper.class);
    private final CategoryService categoryService;

    public CategoryMapper(@Lazy CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public Set<String> toCategoryId(String environmentId, Set<String> categories) {
        return this.toIdentifier(environmentId, categories, CategoryEntity::getId);
    }

    public Set<String> toCategoryKey(String environmentId, Set<String> categories) {
        return this.toIdentifier(environmentId, categories, CategoryEntity::getKey);
    }

    private Set<String> toIdentifier(String environmentId, Set<String> oldCategories, Function<CategoryEntity, String> identifierExtractor) {
        if (CollectionUtils.isEmpty(oldCategories)) {
            return oldCategories;
        }
        return this.categoryService.findAll(environmentId).stream().filter(Objects::nonNull).filter(dbCategory -> this.doesContain(oldCategories, (CategoryEntity)dbCategory)).map(identifierExtractor).collect(Collectors.toSet());
    }

    private boolean doesContain(Set<String> categories, CategoryEntity category) {
        return this.doesContain(categories, category, CategoryEntity::getId) || this.doesContain(categories, category, CategoryEntity::getKey);
    }

    private boolean doesContain(Set<String> categories, CategoryEntity category, Function<CategoryEntity, String> function) {
        return Objects.nonNull(function.apply(category)) && categories.contains(function.apply(category));
    }
}

