/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.portal_page;

import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.core.portal_page.model.PortalPageWithViewDetails;
import io.gravitee.apim.core.portal_page.model.PortalViewContext;
import io.gravitee.apim.core.portal_page.query_service.PortalPageQueryService;
import io.gravitee.apim.infra.adapter.PortalPageAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageContextRepository;
import io.gravitee.repository.management.api.PortalPageRepository;
import io.gravitee.repository.management.model.PortalPage;
import io.gravitee.repository.management.model.PortalPageContext;
import io.gravitee.repository.management.model.PortalPageContextType;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PortalPageQueryServiceImpl
implements PortalPageQueryService {
    private final PortalPageRepository pageRepository;
    private final PortalPageContextRepository contextRepository;
    private final PortalPageAdapter pageAdapter = PortalPageAdapter.INSTANCE;

    public PortalPageQueryServiceImpl(@Lazy PortalPageRepository pageRepository, @Lazy PortalPageContextRepository contextRepository) {
        this.pageRepository = pageRepository;
        this.contextRepository = contextRepository;
    }

    @Override
    public List<PortalPageWithViewDetails> findByEnvironmentIdAndContext(String environmentId, PortalViewContext context) {
        try {
            Map pagesContext = this.contextRepository.findAllByContextTypeAndEnvironmentId(PortalPageContextType.valueOf((String)context.name()), environmentId).stream().collect(Collectors.toMap(PortalPageContext::getPageId, Function.identity()));
            Map<String, PortalPage> pages = this.pageRepository.findByIds(pagesContext.keySet().stream().toList()).stream().collect(Collectors.toMap(PortalPage::getId, p -> p));
            return pages.entrySet().stream().map(e -> new PortalPageWithViewDetails(this.pageAdapter.map((PortalPage)e.getValue()), this.pageAdapter.map((PortalPageContext)pagesContext.get(e.getKey())))).toList();
        }
        catch (TechnicalException e2) {
            throw new TechnicalManagementException("An error occurred while trying to find portal pages viewDetails by environment ID and viewDetails", e2);
        }
    }

    @Override
    public PortalPageWithViewDetails findById(PageId pageId) {
        try {
            PortalPage page = this.pageRepository.findById((Object)pageId.toString()).orElse(null);
            PortalPageContext context = this.contextRepository.findByPageId(pageId.toString());
            return new PortalPageWithViewDetails(this.pageAdapter.map(page), this.pageAdapter.map(context));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException();
        }
    }
}

