/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContextCrudService;
import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.core.portal_page.model.PortalPageView;
import io.gravitee.apim.core.portal_page.model.PortalViewContext;
import io.gravitee.apim.infra.adapter.PortalPageAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageContextRepository;
import io.gravitee.repository.management.model.PortalPageContext;
import io.gravitee.repository.management.model.PortalPageContextType;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalPageContextCrudServiceImpl
implements PortalPageContextCrudService {
    private final PortalPageContextRepository portalPageContextRepository;
    private final PortalPageAdapter pageAdapter = PortalPageAdapter.INSTANCE;

    public PortalPageContextCrudServiceImpl(@Lazy PortalPageContextRepository portalPageContextRepository) {
        this.portalPageContextRepository = portalPageContextRepository;
    }

    @Override
    public List<PageId> findAllIdsByContextTypeAndEnvironmentId(PortalViewContext contextType, String environmentId) {
        PortalPageContextType repoCtx = PortalPageContextType.valueOf((String)contextType.name());
        try {
            return this.portalPageContextRepository.findAllByContextTypeAndEnvironmentId(repoCtx, environmentId).stream().map(PortalPageContext::getPageId).map(PageId::of).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("Something went wrong while trying to find portal page contexts", e);
        }
    }

    @Override
    public PortalPageView findByPageId(PageId pageId) {
        return this.pageAdapter.map(this.portalPageContextRepository.findByPageId(pageId.toString()));
    }
}

