/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContextCrudService;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageCrudService;
import io.gravitee.apim.core.portal_page.domain_service.ContentSanitizedSpecification;
import io.gravitee.apim.core.portal_page.domain_service.PageExistsSpecification;
import io.gravitee.apim.core.portal_page.model.GraviteeMarkdown;
import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.core.portal_page.model.PortalPage;
import io.gravitee.apim.core.portal_page.model.PortalPageWithViewDetails;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class UpdatePortalPageUseCase {
    private final PortalPageCrudService portalPageCrudService;
    private final PortalPageContextCrudService portalPageContextCrudService;

    public Output execute(Input input) {
        PageId pageId = PageId.of(input.pageId);
        Optional<PortalPage> portalPageOpt = this.portalPageCrudService.findById(pageId);
        PageExistsSpecification<Optional> pageExistsSpec = new PageExistsSpecification<Optional>(Optional::isPresent);
        ContentSanitizedSpecification contentSanitizedSpec = new ContentSanitizedSpecification();
        GraviteeMarkdown pageContent = new GraviteeMarkdown(input.content);
        pageExistsSpec.throwIfNotSatisfied(portalPageOpt);
        contentSanitizedSpec.throwIfNotSatisfied(pageContent);
        PortalPage portalPage = portalPageOpt.get();
        portalPage.setContent(pageContent);
        PortalPage updated = this.portalPageCrudService.update(portalPage);
        PortalPageWithViewDetails withDetails = new PortalPageWithViewDetails(updated, this.portalPageContextCrudService.findByPageId(pageId));
        return new Output(withDetails);
    }

    @Generated
    public UpdatePortalPageUseCase(PortalPageCrudService portalPageCrudService, PortalPageContextCrudService portalPageContextCrudService) {
        this.portalPageCrudService = portalPageCrudService;
        this.portalPageContextCrudService = portalPageContextCrudService;
    }

    public record Input(String environmentId, String pageId, String content) {
    }

    public record Output(PortalPageWithViewDetails portalPage) {
    }
}

