/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.model;

import io.gravitee.apim.core.portal_page.model.GraviteeMarkdown;
import io.gravitee.apim.core.portal_page.model.PageId;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class PortalPage {
    @Nonnull
    private final PageId id;
    @Nonnull
    private GraviteeMarkdown pageContent;

    public PortalPage(@Nonnull PageId id, @Nonnull GraviteeMarkdown pageContent) {
        this.id = id;
        this.pageContent = pageContent;
    }

    public static PortalPage create(GraviteeMarkdown pageContent) {
        return new PortalPage(PageId.random(), pageContent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalPage that = (PortalPage)o;
        return this.id.equals(that.id) && this.pageContent.equals(that.pageContent);
    }

    @Nonnull
    public PageId getId() {
        return this.id;
    }

    @Nonnull
    public GraviteeMarkdown getPageContent() {
        return this.pageContent;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pageContent);
    }

    public String toString() {
        return "PortalPage[id=" + String.valueOf(this.id) + ", pageContent=" + String.valueOf(this.pageContent) + "]";
    }

    public void setContent(GraviteeMarkdown pageContent) {
        this.pageContent = pageContent;
    }
}

