/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateNativeApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.domain_service.property.PropertyDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.UpdateNativeApi;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.property.Property;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;

@UseCase
public class UpdateNativeApiUseCase {
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final PropertyDomainService propertyDomainService;
    private final ValidateApiDomainService validateApiDomainService;
    private final UpdateNativeApiDomainService updateNativeApiDomainService;

    public Output execute(Input input) {
        UpdateNativeApi updateApi = input.apiToUpdate;
        AuditInfo auditInfo = input.auditInfo;
        PrimaryOwnerEntity primaryOwnerEntity = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), updateApi.getId());
        List<Property> encryptedProperties = this.propertyDomainService.encryptProperties(input.apiToUpdate().getProperties());
        UnaryOperator<Api> updating = UpdateNativeApiUseCase.update(input.apiToUpdate(), encryptedProperties);
        Api updated = this.updateNativeApiDomainService.update(input.apiToUpdate.getId(), updating, (existingApi, apiToUpdate) -> this.validateApiDomainService.validateAndSanitizeForUpdate((Api)existingApi, (Api)apiToUpdate, primaryOwnerEntity, auditInfo.environmentId(), auditInfo.organizationId()), auditInfo, primaryOwnerEntity, ApiIndexerDomainService.oneShotIndexation(auditInfo));
        return new Output(updated, primaryOwnerEntity);
    }

    static UnaryOperator<Api> update(UpdateNativeApi updateNativeApi, List<Property> properties) {
        return currentApi -> ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)currentApi.toBuilder().name(updateNativeApi.getName())).description(updateNativeApi.getDescription())).version(updateNativeApi.getApiVersion())).apiLifecycleState(updateNativeApi.getLifecycleState())).visibility(updateNativeApi.getVisibility())).labels(updateNativeApi.getLabels())).categories(updateNativeApi.getCategories())).groups(updateNativeApi.getGroups())).disableMembershipNotifications(updateNativeApi.isDisableMembershipNotifications())).apiDefinitionNativeV4(currentApi.getApiDefinitionNativeV4() != null ? ((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)((NativeApi.NativeApiBuilder)currentApi.getApiDefinitionNativeV4().toBuilder().name(updateNativeApi.getName())).apiVersion(updateNativeApi.getApiVersion())).tags(updateNativeApi.getTags())).resources(updateNativeApi.getResources())).listeners(updateNativeApi.getListeners()).endpointGroups(updateNativeApi.getEndpointGroups()).flows(updateNativeApi.getFlows()).services(updateNativeApi.getServices()).properties(properties)).analytics(updateNativeApi.getAnalytics()).build() : null)).build();
    }

    @Generated
    public UpdateNativeApiUseCase(ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, PropertyDomainService propertyDomainService, ValidateApiDomainService validateApiDomainService, UpdateNativeApiDomainService updateNativeApiDomainService) {
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.propertyDomainService = propertyDomainService;
        this.validateApiDomainService = validateApiDomainService;
        this.updateNativeApiDomainService = updateNativeApiDomainService;
    }

    public record Input(UpdateNativeApi apiToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private UpdateNativeApi apiToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiToUpdate(UpdateNativeApi apiToUpdate) {
                this.apiToUpdate = apiToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateNativeApiUseCase.Input.InputBuilder(apiToUpdate=" + String.valueOf(this.apiToUpdate) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(Api updatedApi, PrimaryOwnerEntity primaryOwnerEntity) {
    }
}

