/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.analytics;

import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.model.EventAnalytics;
import io.gravitee.apim.core.analytics.model.GroupByAnalytics;
import io.gravitee.apim.core.analytics.model.HistogramAnalytics;
import io.gravitee.apim.core.analytics.model.ResponseStatusOvertime;
import io.gravitee.apim.core.analytics.model.StatsAnalytics;
import io.gravitee.apim.core.analytics.model.Timestamp;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.infra.adapter.ApiMetricsDetailAdapter;
import io.gravitee.apim.infra.adapter.ResponseStatusQueryCriteriaAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.analytics.query.events.EventAnalyticsQuery;
import io.gravitee.repository.log.v4.api.AnalyticsRepository;
import io.gravitee.repository.log.v4.model.analytics.Aggregation;
import io.gravitee.repository.log.v4.model.analytics.AggregationType;
import io.gravitee.repository.log.v4.model.analytics.ApiMetricsDetailQuery;
import io.gravitee.repository.log.v4.model.analytics.AverageAggregate;
import io.gravitee.repository.log.v4.model.analytics.AverageConnectionDurationQuery;
import io.gravitee.repository.log.v4.model.analytics.AverageMessagesPerRequestQuery;
import io.gravitee.repository.log.v4.model.analytics.GroupByQuery;
import io.gravitee.repository.log.v4.model.analytics.HistogramAggregate;
import io.gravitee.repository.log.v4.model.analytics.HistogramQuery;
import io.gravitee.repository.log.v4.model.analytics.RequestResponseTimeAggregate;
import io.gravitee.repository.log.v4.model.analytics.RequestResponseTimeQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.RequestsCountByEventQuery;
import io.gravitee.repository.log.v4.model.analytics.RequestsCountQuery;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusOverTimeAggregate;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusOverTimeQuery;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.ResponseTimeRangeQuery;
import io.gravitee.repository.log.v4.model.analytics.SearchTermId;
import io.gravitee.repository.log.v4.model.analytics.StatsQuery;
import io.gravitee.repository.log.v4.model.analytics.TimeRange;
import io.gravitee.repository.log.v4.model.analytics.TopFailedAggregate;
import io.gravitee.repository.log.v4.model.analytics.TopFailedQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.TopHitsAggregate;
import io.gravitee.repository.log.v4.model.analytics.TopHitsQueryCriteria;
import io.gravitee.rest.api.model.analytics.TopHitsApps;
import io.gravitee.rest.api.model.v4.analytics.ApiMetricsDetail;
import io.gravitee.rest.api.model.v4.analytics.AverageConnectionDuration;
import io.gravitee.rest.api.model.v4.analytics.AverageMessagesPerRequest;
import io.gravitee.rest.api.model.v4.analytics.RequestResponseTime;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.model.v4.analytics.TopFailedApis;
import io.gravitee.rest.api.model.v4.analytics.TopHitsApis;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Maybe;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsQueryServiceImpl
implements AnalyticsQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsQueryServiceImpl.class);
    private final AnalyticsRepository analyticsRepository;

    public AnalyticsQueryServiceImpl(@Lazy AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    private static HistogramAnalytics.Bucket mapBuckets(HistogramAggregate histogramAggregate) {
        if (histogramAggregate instanceof HistogramAggregate.Counts) {
            HistogramAggregate.Counts counts = (HistogramAggregate.Counts)histogramAggregate;
            return new HistogramAnalytics.CountBucket(counts.name(), counts.field(), counts.counts());
        }
        if (histogramAggregate instanceof HistogramAggregate.Metric) {
            HistogramAggregate.Metric metrics = (HistogramAggregate.Metric)histogramAggregate;
            return new HistogramAnalytics.MetricBucket(metrics.name(), metrics.field(), metrics.values());
        }
        log.error("Unsupported histogram aggregate type {}", (Object)histogramAggregate.getClass());
        return null;
    }

    @Override
    public Optional<RequestsCount> searchRequestsCount(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchRequestsCount(executionContext.getQueryContext(), new RequestsCountQuery(apiId, from, to)).map(countAggregate -> RequestsCount.builder().total(Long.valueOf(countAggregate.getTotal())).countsByEntrypoint(countAggregate.getCountBy()).build());
    }

    @Override
    public Optional<AverageMessagesPerRequest> searchAverageMessagesPerRequest(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchAverageMessagesPerRequest(executionContext.getQueryContext(), new AverageMessagesPerRequestQuery(apiId, from, to)).map(averageAggregate -> AverageMessagesPerRequest.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }

    @Override
    public Optional<ResponseStatusRanges> searchResponseStatusRanges(ExecutionContext executionContext, AnalyticsQueryParameters queryParameters) {
        ResponseStatusQueryCriteria responseStatusQueryParameters = ResponseStatusQueryCriteriaAdapter.INSTANCE.map(queryParameters);
        Optional queryResult = this.analyticsRepository.searchResponseStatusRanges(executionContext.getQueryContext(), responseStatusQueryParameters);
        return queryResult.map(analytics -> ResponseStatusRanges.builder().ranges(analytics.getRanges()).statusRangesCountByEntrypoint(analytics.getStatusRangesCountByEntrypoint()).build());
    }

    @Override
    public Optional<TopHitsApis> searchTopHitsApis(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopHitsApi(executionContext.getQueryContext(), new TopHitsQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopHitsAggregate::getTopHitsCounts).map(topHitCounts -> topHitCounts.entrySet().stream().map(entry -> TopHitsApis.TopHitApi.builder().id((String)entry.getKey()).count(((Long)entry.getValue()).longValue()).build()).toList()).map(topHitApis -> TopHitsApis.builder().data(topHitApis).build());
    }

    @Override
    public Optional<AverageConnectionDuration> searchAverageConnectionDuration(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchAverageConnectionDuration(executionContext.getQueryContext(), new AverageConnectionDurationQuery(apiId, from, to)).map(averageAggregate -> AverageConnectionDuration.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }

    @Override
    public Maybe<Map<String, Double>> searchAvgResponseTimeOverTime(ExecutionContext executionContext, List<String> apiIds, Instant startTime, Instant endTime, Duration interval, Collection<DefinitionVersion> versions) {
        return this.analyticsRepository.searchResponseTimeOverTime(executionContext.getQueryContext(), new ResponseTimeRangeQuery(apiIds, startTime, endTime, interval, versions)).map(AverageAggregate::getAverageBy);
    }

    @Override
    public ResponseStatusOvertime searchResponseStatusOvertime(ExecutionContext executionContext, AnalyticsQueryService.ResponseStatusOverTimeQuery query) {
        ResponseStatusOverTimeAggregate result = this.analyticsRepository.searchResponseStatusOvertime(executionContext.getQueryContext(), new ResponseStatusOverTimeQuery(query.apiIds(), query.from(), query.to(), query.interval(), query.versions()));
        return ResponseStatusOvertime.builder().data(result.getStatusCount()).timeRange(new ResponseStatusOvertime.TimeRange(query.from(), query.to(), query.interval())).build();
    }

    @Override
    public Optional<TopHitsApps> searchTopHitsApps(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopApps(executionContext.getQueryContext(), new TopHitsQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopHitsAggregate::getTopHitsCounts).map(topHitCounts -> topHitCounts.entrySet().stream().map(entry -> TopHitsApps.TopHitApp.builder().id((String)entry.getKey()).count(((Long)entry.getValue()).longValue()).build()).toList()).map(topHitApp -> TopHitsApps.builder().data(topHitApp).build());
    }

    @Override
    public RequestResponseTime searchRequestResponseTime(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        RequestResponseTimeAggregate result = this.analyticsRepository.searchRequestResponseTimes(executionContext.getQueryContext(), new RequestResponseTimeQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo(), parameters.getDefinitionVersions()));
        return RequestResponseTime.builder().requestsPerSecond(Double.valueOf(result.getRequestsPerSecond())).requestsTotal(Long.valueOf(result.getRequestsTotal())).responseMinTime(Double.valueOf(result.getResponseMinTime())).responseMaxTime(Double.valueOf(result.getResponseMaxTime())).responseAvgTime(Double.valueOf(result.getResponseAvgTime())).build();
    }

    @Override
    public Optional<TopFailedApis> searchTopFailedApis(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopFailedApis(executionContext.getQueryContext(), new TopFailedQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopFailedAggregate::failedApis).map(topFailedApis -> topFailedApis.entrySet().stream().map(entry -> TopFailedApis.TopFailedApi.builder().id((String)entry.getKey()).failedCalls(((TopFailedAggregate.FailedApiInfo)entry.getValue()).failedCalls()).failedCallsRatio(((TopFailedAggregate.FailedApiInfo)entry.getValue()).failedCallsRatio()).build()).toList()).map(topFailedApi -> TopFailedApis.builder().data(topFailedApi).build());
    }

    @Override
    public Optional<HistogramAnalytics> searchHistogramAnalytics(ExecutionContext executionContext, AnalyticsQueryService.HistogramQuery histogramParameters) {
        List repoResult;
        List repoAggregations = null;
        if (histogramParameters.aggregations() != null) {
            repoAggregations = histogramParameters.aggregations().stream().map(agg -> new Aggregation(agg.getField(), AggregationType.valueOf((String)agg.getAggregationType().name()))).collect(Collectors.toList());
        }
        if ((repoResult = this.analyticsRepository.searchHistogram(executionContext.getQueryContext(), new HistogramQuery(AnalyticsQueryServiceImpl.toModelSearchTermId(histogramParameters.searchTermId()), new TimeRange(histogramParameters.from(), histogramParameters.to(), histogramParameters.interval()), repoAggregations, histogramParameters.query()))) == null || repoResult.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.mapHistogramAggregatesToHistogramAnalytics(repoResult, histogramParameters));
    }

    private static SearchTermId toModelSearchTermId(AnalyticsQueryService.SearchTermId searchTermId) {
        return new SearchTermId(SearchTermId.SearchTerm.valueOf((String)searchTermId.searchTerm().name()), searchTermId.id());
    }

    @Override
    public Optional<GroupByAnalytics> searchGroupByAnalytics(ExecutionContext executionContext, AnalyticsQueryService.GroupByQuery groupByQuery) {
        List<GroupByQuery.Group> repoGroups = groupByQuery.groups().stream().map(g -> new GroupByQuery.Group(g.from(), g.to())).toList();
        GroupByQuery repoQuery = AnalyticsQueryServiceImpl.getGroupByQuery(groupByQuery, repoGroups);
        return this.analyticsRepository.searchGroupBy(executionContext.getQueryContext(), repoQuery).map(groupByAggregate -> {
            GroupByAnalytics analytics = new GroupByAnalytics();
            analytics.setValues(groupByAggregate.values());
            analytics.setOrder(groupByAggregate.order());
            return analytics;
        });
    }

    private static @NotNull GroupByQuery getGroupByQuery(AnalyticsQueryService.GroupByQuery groupByQuery, List<GroupByQuery.Group> repoGroups) {
        Optional<GroupByQuery.Order> repoOrder = groupByQuery.order().map(order -> new GroupByQuery.Order(order.field(), order.order(), order.type()));
        return new GroupByQuery(AnalyticsQueryServiceImpl.toModelSearchTermId(groupByQuery.searchTermId()), groupByQuery.field(), repoGroups, repoOrder, new TimeRange(groupByQuery.from(), groupByQuery.to()), groupByQuery.query());
    }

    @Override
    public Optional<StatsAnalytics> searchStatsAnalytics(ExecutionContext executionContext, AnalyticsQueryService.StatsQuery statsQuery) {
        StatsQuery repoQuery = new StatsQuery(statsQuery.field(), AnalyticsQueryServiceImpl.toModelSearchTermId(statsQuery.searchTermId()), new TimeRange(statsQuery.from(), statsQuery.to()), statsQuery.query());
        return this.analyticsRepository.searchStats(executionContext.getQueryContext(), repoQuery).map(statsAggregate -> new StatsAnalytics(statsAggregate.avg(), statsAggregate.min(), statsAggregate.max(), statsAggregate.sum(), statsAggregate.count(), statsAggregate.rps(), statsAggregate.rpm(), statsAggregate.rph()));
    }

    @Override
    public Optional<RequestsCount> searchRequestsCountByEvent(ExecutionContext executionContext, AnalyticsQueryService.CountQuery countParameters) {
        return this.analyticsRepository.searchRequestsCountByEvent(executionContext.getQueryContext(), new RequestsCountByEventQuery(AnalyticsQueryServiceImpl.toModelSearchTermId(countParameters.searchTermId()), new TimeRange(countParameters.from(), countParameters.to()), countParameters.query())).map(countAggregate -> RequestsCount.builder().total(Long.valueOf(countAggregate.total())).build());
    }

    @Override
    public Optional<ApiMetricsDetail> findApiMetricsDetail(ExecutionContext executionContext, String apiId, String requestId) {
        return this.analyticsRepository.findApiMetricsDetail(executionContext.getQueryContext(), new ApiMetricsDetailQuery(apiId, requestId)).map(ApiMetricsDetailAdapter.INSTANCE::map);
    }

    @Override
    public Optional<EventAnalytics> searchEventAnalytics(ExecutionContext executionContext, AnalyticsQueryService.EventAnalyticsParams params) {
        ArrayList aggregations = new ArrayList();
        params.aggregations().forEach(aggregation -> Arrays.stream(AggregationType.values()).filter(value -> value.name().equals(aggregation.getAggregationType().name())).findFirst().ifPresent(type -> aggregations.add(new Aggregation(aggregation.getField(), type))));
        EventAnalyticsQuery query = new EventAnalyticsQuery(params.apiId(), new TimeRange(params.from(), params.to(), Optional.of(params.interval())), aggregations);
        Optional aggregate = this.analyticsRepository.searchEventAnalytics(executionContext.getQueryContext(), query);
        return aggregate.map(analyticsAggregate -> new EventAnalytics(analyticsAggregate.values()));
    }

    private HistogramAnalytics mapHistogramAggregatesToHistogramAnalytics(List<HistogramAggregate> aggregates, AnalyticsQueryService.HistogramQuery histogramParameters) {
        Timestamp timestamp = new Timestamp(histogramParameters.from(), histogramParameters.to(), histogramParameters.interval());
        List<HistogramAnalytics.Bucket> values = aggregates.stream().map(AnalyticsQueryServiceImpl::mapBuckets).toList();
        return new HistogramAnalytics(timestamp, values);
    }
}

