/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case.members;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.member.model.Member;
import io.gravitee.apim.core.member.model.MembershipMember;
import io.gravitee.apim.core.member.model.MembershipMemberType;
import io.gravitee.apim.core.member.model.MembershipReference;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.member.model.MembershipRole;
import io.gravitee.apim.core.member.model.RoleScope;
import io.gravitee.apim.core.member.query_service.MemberQueryService;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import lombok.Generated;

@UseCase
public class UpdateClusterMemberUseCase {
    private final MemberQueryService memberQueryService;

    public Output execute(Input input) {
        this.validate(input.newRole);
        MembershipReference reference = new MembershipReference(MembershipReferenceType.CLUSTER, input.clusterId);
        MembershipMember member = MembershipMember.builder().memberId(input.memberId).memberType(MembershipMemberType.USER).build();
        MembershipRole role = MembershipRole.builder().scope(RoleScope.CLUSTER).name(input.newRole).build();
        Member updatedMember = this.memberQueryService.updateRoleToMemberOnReference(reference, member, role);
        return new Output(updatedMember);
    }

    private void validate(String newRole) {
        if (SystemRole.PRIMARY_OWNER.name().equals(newRole)) {
            throw new SinglePrimaryOwnerException(io.gravitee.rest.api.model.permissions.RoleScope.CLUSTER);
        }
    }

    @Generated
    public UpdateClusterMemberUseCase(MemberQueryService memberQueryService) {
        this.memberQueryService = memberQueryService;
    }

    public record Input(String newRole, String memberId, String clusterId) {
    }

    public record Output(Member updatedMember) {
    }
}

