/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.model.utils.MigrationResult;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProvider;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyProviderConfiguration;
import io.gravitee.definition.model.services.dynamicproperty.DynamicPropertyService;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckStep;
import io.gravitee.definition.model.services.schedule.ScheduledService;
import io.gravitee.definition.model.v4.service.Service;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiServicesMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServicesMigration.class);
    private final ObjectMapper jsonMapper;
    private static final String TYPE_ENDPOINT = "ENDPOINT";
    private static final List<String> ALLOWED_DISCOVERY_PLUGIN_IDS = List.of("consul-service-discovery");

    public MigrationResult<Service> convert(io.gravitee.definition.model.Service v2Service, String type, String name) {
        io.gravitee.definition.model.Service service = v2Service;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicPropertyService.class, EndpointHealthCheckService.class, HealthCheckService.class, ScheduledService.class, EndpointDiscoveryService.class}, (Object)service, n)) {
            case 0 -> {
                DynamicPropertyService v2dynamicPropertyService = (DynamicPropertyService)service;
                yield this.convertDynamicPropertyService(v2dynamicPropertyService);
            }
            case 1 -> {
                EndpointHealthCheckService vEP2HealthCheckService = (EndpointHealthCheckService)service;
                yield this.convertEPHealthCheckService(vEP2HealthCheckService, type, name);
            }
            case 2 -> {
                HealthCheckService v2HealthCheckService = (HealthCheckService)service;
                yield this.convertHealthCheckService(v2HealthCheckService, type, name);
            }
            case 3 -> {
                ScheduledService v2ScheduledService = (ScheduledService)service;
                yield null;
            }
            case 4 -> {
                EndpointDiscoveryService v2EndpointDiscoveryService = (EndpointDiscoveryService)service;
                yield ApiServicesMigration.mapServiceDiscovery(v2EndpointDiscoveryService);
            }
            case -1 -> null;
            default -> MigrationResult.issue("Unsupported Service", MigrationResult.State.IMPOSSIBLE);
        };
    }

    private MigrationResult<Service> convertHealthCheckService(HealthCheckService v2HealthCheckService, String type, String name) {
        ObjectNode config = this.jsonMapper.createObjectNode();
        MigrationResult<Service> migrationResult = MigrationResult.value(Service.builder().enabled(v2HealthCheckService.isEnabled()).overrideConfiguration(false).type("http-health-check").build());
        String endpointReferenceForMessage = String.format("%s : %s", type.equals(TYPE_ENDPOINT) ? "endpoint" : "endpointgroup", name);
        if (v2HealthCheckService.getSchedule() != null) {
            config.put("schedule", v2HealthCheckService.getSchedule());
        } else {
            config.putNull("schedule");
        }
        config.put("failureThreshold", 2);
        config.put("successThreshold", 2);
        List steps = v2HealthCheckService.getSteps();
        switch (CollectionUtils.size(steps)) {
            case 0: {
                break;
            }
            case 1: {
                HealthCheckStep step = (HealthCheckStep)steps.getFirst();
                if (CollectionUtils.size(step.getResponse().getAssertions()) > 1) {
                    log.error("Health check for {} cannot have more than one assertion", (Object)endpointReferenceForMessage);
                    migrationResult.addIssue("Health check for %s cannot have more than one assertion".formatted(endpointReferenceForMessage), MigrationResult.State.IMPOSSIBLE);
                }
                try {
                    config.set("headers", (JsonNode)(step.getRequest().getHeaders() == null ? this.jsonMapper.createArrayNode() : this.jsonMapper.valueToTree((Object)step.getRequest().getHeaders())));
                    config.set("method", this.jsonMapper.valueToTree((Object)step.getRequest().getMethod()));
                    config.set("target", this.jsonMapper.valueToTree((Object)step.getRequest().getPath()));
                    config.set("assertion", this.jsonMapper.valueToTree((Object)StringUtils.appendCurlyBraces((String)step.getResponse().getAssertions().getFirst())));
                    config.set("overrideEndpointPath", this.jsonMapper.valueToTree((Object)step.getRequest().isFromRoot()));
                    break;
                }
                catch (Exception e) {
                    log.error("Unable to map configuration for Health check ", (Throwable)e);
                    return migrationResult.addIssue("Unable to map configuration for Health check", MigrationResult.State.IMPOSSIBLE);
                }
            }
            default: {
                log.error("Health check for {} cannot have more than one step ", (Object)endpointReferenceForMessage);
                migrationResult.addIssue("Health check for %s cannot have more than one step".formatted(endpointReferenceForMessage), MigrationResult.State.IMPOSSIBLE);
            }
        }
        return migrationResult.map(ser -> {
            ser.setConfiguration(config.toString());
            return ser;
        });
    }

    private MigrationResult<Service> convertEPHealthCheckService(EndpointHealthCheckService v2EPHealthCheckService, String type, String name) {
        return this.convertHealthCheckService((HealthCheckService)v2EPHealthCheckService, type, name).map(plainHealthCheckService -> {
            plainHealthCheckService.setOverrideConfiguration(!v2EPHealthCheckService.isInherit());
            return plainHealthCheckService;
        });
    }

    private MigrationResult<Service> convertDynamicPropertyService(DynamicPropertyService v2dynamicPropertyService) {
        if (v2dynamicPropertyService == null) {
            return MigrationResult.value(new Service());
        }
        ObjectNode configNode = this.jsonMapper.createObjectNode();
        MigrationResult<Service> migrationResult = MigrationResult.value(Service.builder().overrideConfiguration(false).type("http-dynamic-properties").enabled(v2dynamicPropertyService.isEnabled()).build());
        try {
            configNode.put("schedule", v2dynamicPropertyService.getSchedule());
            if (v2dynamicPropertyService.getProvider() != null && !v2dynamicPropertyService.getProvider().equals((Object)DynamicPropertyProvider.HTTP)) {
                String errorMessage = "Unable to migrate Dynamic properties configuration as provider is different from HTTP";
                log.error(errorMessage);
                return migrationResult.addIssue(new MigrationResult.Issue(errorMessage, MigrationResult.State.IMPOSSIBLE));
            }
            DynamicPropertyProviderConfiguration dynamicPropertyProviderConfiguration = v2dynamicPropertyService.getConfiguration();
            if (dynamicPropertyProviderConfiguration instanceof HttpDynamicPropertyProviderConfiguration) {
                HttpDynamicPropertyProviderConfiguration httpDPProviderConfiguration = (HttpDynamicPropertyProviderConfiguration)dynamicPropertyProviderConfiguration;
                configNode.set("headers", this.jsonMapper.valueToTree((Object)(httpDPProviderConfiguration.getHeaders() != null ? httpDPProviderConfiguration.getHeaders() : this.jsonMapper.createArrayNode())));
                configNode.put("method", httpDPProviderConfiguration.getMethod().name());
                configNode.put("systemProxy", httpDPProviderConfiguration.isUseSystemProxy());
                configNode.put("transformation", httpDPProviderConfiguration.getSpecification());
                configNode.put("url", httpDPProviderConfiguration.getUrl());
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to map configuration for Dynamic Property Service";
            log.error(errorMessage, (Throwable)e);
            return migrationResult.addIssue(new MigrationResult.Issue(errorMessage, MigrationResult.State.IMPOSSIBLE));
        }
        return migrationResult.map(service -> {
            service.setConfiguration(configNode.toString());
            return service;
        });
    }

    private static MigrationResult<Service> mapServiceDiscovery(EndpointDiscoveryService discoveryService) {
        if (discoveryService == null || discoveryService.getProvider() == null) {
            return MigrationResult.value(new Service());
        }
        if (!ALLOWED_DISCOVERY_PLUGIN_IDS.contains(discoveryService.getProvider())) {
            return MigrationResult.issue("Service discovery provider '%s' is not supported for migration. Only consul-service-discovery is supported.".formatted(discoveryService.getProvider()), MigrationResult.State.IMPOSSIBLE);
        }
        Service service = Service.builder().configuration(discoveryService.getConfiguration()).type(discoveryService.getProvider()).enabled(discoveryService.isEnabled()).build();
        return MigrationResult.value(service).addIssue("Service discovery configuration can be migrated, but the configuration page will not be available in the new version.", MigrationResult.State.CAN_BE_FORCED);
    }

    @Generated
    public ApiServicesMigration(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }
}

