/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.v4.analytics.ApiMetricsDetail;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class FindApiMetricsDetailUseCase {
    static final String UNKNOWN = "Unknown";
    private final AnalyticsQueryService analyticsQueryService;
    private final ApplicationCrudService applicationCrudService;
    private final PlanCrudService planCrudService;

    public Output execute(ExecutionContext executionContext, Input input) {
        return this.analyticsQueryService.findApiMetricsDetail(executionContext, input.apiId(), input.requestId).map(apiMetricsDetail -> this.mapToModel(executionContext, (ApiMetricsDetail)apiMetricsDetail)).orElse(new Output());
    }

    private Output mapToModel(ExecutionContext executionContext, ApiMetricsDetail apiMetricsDetail) {
        io.gravitee.apim.core.analytics.model.ApiMetricsDetail result = io.gravitee.apim.core.analytics.model.ApiMetricsDetail.builder().timestamp(apiMetricsDetail.getTimestamp()).apiId(apiMetricsDetail.getApiId()).requestId(apiMetricsDetail.getRequestId()).transactionId(apiMetricsDetail.getTransactionId()).host(apiMetricsDetail.getHost()).application(this.getApplication(executionContext.getEnvironmentId(), apiMetricsDetail.getApplicationId())).plan(this.getPlan(apiMetricsDetail.getPlanId())).gateway(apiMetricsDetail.getGateway()).uri(apiMetricsDetail.getUri()).status(apiMetricsDetail.getStatus()).requestContentLength(apiMetricsDetail.getRequestContentLength()).responseContentLength(apiMetricsDetail.getResponseContentLength()).remoteAddress(apiMetricsDetail.getRemoteAddress()).gatewayLatency(apiMetricsDetail.getGatewayLatency()).gatewayResponseTime(apiMetricsDetail.getGatewayResponseTime()).endpointResponseTime(apiMetricsDetail.getEndpointResponseTime()).method(apiMetricsDetail.getMethod()).endpoint(apiMetricsDetail.getEndpoint()).build();
        return new Output(result);
    }

    private BaseApplicationEntity getApplication(String environmentId, String applicationId) {
        BaseApplicationEntity unknownApp = BaseApplicationEntity.builder().id(applicationId).name(UNKNOWN).build();
        try {
            return applicationId != null ? this.applicationCrudService.findById(applicationId, environmentId) : unknownApp;
        }
        catch (ApplicationNotFoundException | TechnicalManagementException e) {
            return unknownApp;
        }
    }

    private GenericPlanEntity getPlan(String planId) {
        BasePlanEntity unknownPlan = BasePlanEntity.builder().id(planId).name(UNKNOWN).build();
        try {
            return planId != null ? this.planCrudService.getById(planId) : unknownPlan;
        }
        catch (PlanNotFoundException | TechnicalManagementException e) {
            return unknownPlan;
        }
    }

    @Generated
    public FindApiMetricsDetailUseCase(AnalyticsQueryService analyticsQueryService, ApplicationCrudService applicationCrudService, PlanCrudService planCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.applicationCrudService = applicationCrudService;
        this.planCrudService = planCrudService;
    }

    public record Input(String apiId, String requestId) {
    }

    public record Output(Optional<io.gravitee.apim.core.analytics.model.ApiMetricsDetail> apiMetricsDetail) {
        Output(io.gravitee.apim.core.analytics.model.ApiMetricsDetail apiMetricsDetail) {
            this(Optional.of(apiMetricsDetail));
        }

        Output() {
            this(Optional.empty());
        }
    }
}

