/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.model;

import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;

public sealed interface Integration {
    public String id();

    public String name();

    public String description();

    public String provider();

    public String environmentId();

    public ZonedDateTime createdAt();

    public ZonedDateTime updatedAt();

    public Set<String> groups();

    public static ApiIntegration create(ApiIntegration integration) {
        ZonedDateTime now = TimeProvider.now();
        return new ApiIntegration(UuidString.generateRandom(), integration.name(), integration.description(), integration.provider(), integration.environmentId(), now, now, Set.of());
    }

    public static A2aIntegration create(A2aIntegration integration) {
        ZonedDateTime now = TimeProvider.now();
        return new A2aIntegration(UuidString.generateRandom(), integration.name(), integration.description(), integration.provider(), integration.environmentId(), now, now, Set.of(), integration.wellKnownUrls());
    }

    public record ApiIntegration(String id, String name, String description, String provider, String environmentId, ZonedDateTime createdAt, ZonedDateTime updatedAt, Set<String> groups) implements Integration
    {
        public ApiIntegration update(String name, String description, Set<String> groups) {
            return new ApiIntegration(this.id, name, description, this.provider, this.environmentId, this.createdAt, TimeProvider.now(), groups);
        }

        public ApiIntegration withId(String id) {
            return new ApiIntegration(id, this.name, this.description, this.provider, this.environmentId, this.createdAt, this.updatedAt, this.groups);
        }

        public ApiIntegration withEnvironmentId(String environmentId) {
            return new ApiIntegration(this.id, this.name, this.description, this.provider, environmentId, this.createdAt, this.updatedAt, this.groups);
        }
    }

    public record A2aIntegration(String id, String name, String description, String provider, String environmentId, ZonedDateTime createdAt, ZonedDateTime updatedAt, Set<String> groups, Collection<WellKnownUrl> wellKnownUrls) implements Integration
    {
        public A2aIntegration update(String name, String description, Set<String> groups, Collection<WellKnownUrl> wellKnownUrls) {
            return new A2aIntegration(this.id, name, description, this.provider, this.environmentId, this.createdAt, TimeProvider.now(), groups, wellKnownUrls);
        }

        public A2aIntegration withEnvironmentId(String environmentId) {
            return new A2aIntegration(this.id, this.name, this.description, this.provider, environmentId, this.createdAt, this.updatedAt, this.groups, this.wellKnownUrls);
        }

        public record WellKnownUrl(String url) {
        }
    }
}

