/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.AbstractApi;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.NewEventEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.EventNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.mapper.PlanMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventServiceImpl
extends TransactionalService
implements EventService {
    private final Logger LOGGER = LoggerFactory.getLogger(EventServiceImpl.class);
    @Lazy
    @Autowired
    private EventRepository eventRepository;
    @Lazy
    @Autowired
    private EventLatestRepository eventLatestRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private PlanService planService;
    @Autowired
    private PlanQueryService planQueryService;
    @Autowired
    private io.gravitee.rest.api.service.v4.PlanService planServiceV4;
    @Autowired
    private io.gravitee.rest.api.service.configuration.flow.FlowService flowService;
    @Autowired
    private FlowCrudService flowCrudService;
    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private FlowService flowServiceV4;
    @Autowired
    private PlanConverter planConverter;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public EventEntity findById(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Find event by ID: {}", (Object)id);
            Optional event = this.eventRepository.findById((Object)id);
            if (event.isPresent()) {
                return this.convert(executionContext, (Event)event.get());
            }
            throw new EventNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an event using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an event using its ID " + id, ex);
        }
    }

    @Override
    public EventEntity createApiEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, String apiId, Map<String, String> properties) {
        Map<String, String> eventProperties = EventServiceImpl.initializeEventProperties(properties);
        if (apiId != null) {
            eventProperties.put(Event.EventProperties.API_ID.getValue(), apiId);
        }
        EventEntity event = this.createEvent(executionContext, environmentsIds, organizationId, type, null, eventProperties);
        this.createOrPatchLatestEvent(apiId, organizationId, event);
        return event;
    }

    @Override
    public EventEntity createApiEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, io.gravitee.repository.management.model.Api api, Map<String, String> properties) {
        io.gravitee.repository.management.model.Api apiDefinition;
        Map<String, String> eventProperties = EventServiceImpl.initializeEventProperties(properties);
        io.gravitee.repository.management.model.Api api2 = apiDefinition = api != null ? this.buildApiEventPayload(executionContext, api) : null;
        if (apiDefinition != null) {
            eventProperties.put(Event.EventProperties.API_ID.getValue(), apiDefinition.getId());
        }
        EventEntity event = this.createEvent(executionContext, environmentsIds, organizationId, type, apiDefinition, eventProperties);
        if (apiDefinition != null) {
            this.createOrPatchLatestEvent(apiDefinition.getId(), organizationId, event);
        }
        return event;
    }

    @Override
    public EventEntity createDictionaryEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, Dictionary dictionary) {
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        if (dictionary != null) {
            eventProperties.put(Event.EventProperties.DICTIONARY_ID.getValue(), dictionary.getId());
        }
        EventEntity event = this.createEvent(executionContext, environmentsIds, organizationId, type, dictionary, eventProperties);
        if (dictionary != null) {
            this.createOrPatchLatestEvent(dictionary.getId(), organizationId, event);
        }
        return event;
    }

    @Override
    public EventEntity createDynamicDictionaryEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, String dictionaryId) {
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        if (dictionaryId != null) {
            eventProperties.put(Event.EventProperties.DICTIONARY_ID.getValue(), dictionaryId);
        }
        EventEntity event = this.createEvent(executionContext, environmentsIds, organizationId, type, null, eventProperties);
        this.createOrPatchLatestEvent(dictionaryId + "-dynamic", organizationId, event);
        return event;
    }

    @Override
    public EventEntity createOrganizationEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, OrganizationEntity organization) {
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        if (organization != null) {
            eventProperties.put(Event.EventProperties.ORGANIZATION_ID.getValue(), organization.getId());
        }
        EventEntity event = this.createEvent(executionContext, environmentsIds, organizationId, type, organization, eventProperties);
        if (organization != null) {
            this.createOrPatchLatestEvent(organization.getId(), organizationId, event);
        }
        return event;
    }

    private static Map<String, String> initializeEventProperties(Map<String, String> properties) {
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        if (properties != null) {
            eventProperties = new HashMap<String, String>(properties);
        }
        return eventProperties;
    }

    @Override
    public EventEntity createEvent(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, io.gravitee.rest.api.model.EventType type, Object object, Map<String, String> properties) {
        try {
            String payload = object != null ? this.objectMapper.writeValueAsString(object) : null;
            NewEventEntity event = NewEventEntity.builder().type(type).payload(payload).properties(properties).build();
            return this.createNewEventEntity(executionContext, environmentsIds, organizationId, event);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException(String.format("Failed to create event [%s]", type), e);
        }
    }

    protected EventEntity createNewEventEntity(ExecutionContext executionContext, Set<String> environmentsIds, String organizationId, NewEventEntity newEventEntity) {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.LOGGER.debug("Create {} for server {}", (Object)newEventEntity, (Object)hostAddress);
            Event event = this.convert(newEventEntity);
            event.setId(UuidString.generateRandom());
            event.setEnvironments(environmentsIds);
            event.setOrganizations(Set.of(organizationId));
            event.getProperties().put(Event.EventProperties.ORIGIN.getValue(), hostAddress);
            event.setCreatedAt(new Date());
            event.setUpdatedAt(event.getCreatedAt());
            Event createdEvent = (Event)this.eventRepository.create((Object)event);
            return this.convert(executionContext, createdEvent);
        }
        catch (UnknownHostException e) {
            this.LOGGER.error("An error occurs while getting the server IP address", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while getting the server IP address", e);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for server {}", new Object[]{newEventEntity, hostAddress, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + String.valueOf(newEventEntity) + " for server " + hostAddress, ex);
        }
    }

    @Override
    public void deleteApiEvents(String apiId) {
        try {
            this.LOGGER.debug("Delete Events for API {}", (Object)apiId);
            long deleteApiEvents = this.eventRepository.deleteApiEvents(apiId);
            this.LOGGER.debug("{} events deleted for API {}", (Object)deleteApiEvents, (Object)apiId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete Events for API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Events for API " + apiId, ex);
        }
        try {
            this.LOGGER.debug("Delete Event Latest {}", (Object)apiId);
            this.eventLatestRepository.delete(apiId);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to delete Event Latest " + apiId, ex);
        }
    }

    @Override
    public Page<EventEntity> search(ExecutionContext executionContext, List<io.gravitee.rest.api.model.EventType> eventTypes, Map<String, Object> properties, Long from, Long to, int page, int size, List<String> environmentsIds) {
        EventCriteria.EventCriteriaBuilder builder = EventCriteria.builder();
        if (from != null) {
            builder.from(from.longValue());
        }
        if (to != null) {
            builder.to(to.longValue());
        }
        if (eventTypes != null) {
            eventTypes.forEach(eventType -> builder.type(EventType.valueOf((String)eventType.name())));
        }
        if (properties != null) {
            builder.properties(properties);
        }
        builder.environments(environmentsIds);
        return this.eventRepository.search(builder.build(), new PageableBuilder().pageNumber(page).pageSize(size).build()).map(event -> this.convert(executionContext, (Event)event));
    }

    @Override
    public Collection<EventEntity> search(ExecutionContext executionContext, EventQuery query) {
        this.LOGGER.debug("Search APIs by {}", (Object)query);
        return this.convert(executionContext, this.eventRepository.search(this.queryToCriteria(query).build()));
    }

    private EventCriteria.EventCriteriaBuilder queryToCriteria(EventQuery query) {
        EventCriteria.EventCriteriaBuilder builder = EventCriteria.builder();
        if (query == null) {
            return builder;
        }
        if (query.getOrganizationIds() != null) {
            builder.organizations(query.getOrganizationIds());
        }
        if (query.getEnvironmentIds() != null) {
            builder.environments(query.getEnvironmentIds());
        }
        builder.from(query.getFrom()).to(query.getTo());
        if (!CollectionUtils.isEmpty((Collection)query.getTypes())) {
            query.getTypes().forEach(eventType -> builder.type(EventType.valueOf((String)eventType.name())));
        }
        if (!CollectionUtils.isEmpty((Map)query.getProperties())) {
            builder.properties(query.getProperties());
        }
        if (!StringUtils.isBlank((CharSequence)query.getApi())) {
            builder.property(Event.EventProperties.API_ID.getValue(), (Object)query.getApi());
        }
        if (!StringUtils.isBlank((CharSequence)query.getId())) {
            builder.property(Event.EventProperties.ID.getValue(), (Object)query.getId());
        }
        return builder;
    }

    private Set<EventEntity> convert(ExecutionContext executionContext, List<Event> events) {
        return events.stream().map(event -> this.convert(executionContext, (Event)event)).collect(Collectors.toSet());
    }

    private EventEntity convert(ExecutionContext executionContext, Event event) {
        String userId;
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(event.getId());
        eventEntity.setType(io.gravitee.rest.api.model.EventType.valueOf((String)event.getType().toString()));
        eventEntity.setPayload(event.getPayload());
        eventEntity.setParentId(event.getParentId());
        eventEntity.setProperties(event.getProperties());
        eventEntity.setCreatedAt(event.getCreatedAt());
        eventEntity.setUpdatedAt(event.getUpdatedAt());
        eventEntity.setEnvironments(event.getEnvironments());
        if (event.getProperties() != null && (userId = (String)event.getProperties().get(Event.EventProperties.USER.getValue())) != null && !userId.isEmpty()) {
            try {
                eventEntity.setUser(this.userService.findById(executionContext, userId));
            }
            catch (UserNotFoundException unfe) {
                UserEntity user = new UserEntity();
                user.setSource("system");
                user.setId(userId);
                eventEntity.setUser(user);
            }
        }
        return eventEntity;
    }

    private Event convert(NewEventEntity newEventEntity) {
        Event event = new Event();
        event.setType(EventType.valueOf((String)newEventEntity.getType().toString()));
        event.setPayload(newEventEntity.getPayload());
        event.setParentId(newEventEntity.getParentId());
        event.setProperties(new HashMap(newEventEntity.getProperties()));
        return event;
    }

    private io.gravitee.repository.management.model.Api buildApiEventPayload(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) {
        try {
            io.gravitee.repository.management.model.Api apiForGatewayEvent = new io.gravitee.repository.management.model.Api(api);
            if (api.getDefinitionVersion() == null || !api.getDefinitionVersion().equals((Object)DefinitionVersion.V4) && !api.getDefinitionVersion().equals((Object)DefinitionVersion.FEDERATED)) {
                apiForGatewayEvent.setDefinition(this.objectMapper.writeValueAsString((Object)this.buildGatewayApiDefinition(executionContext, api)));
            } else {
                apiForGatewayEvent.setDefinition(this.objectMapper.writeValueAsString((Object)this.buildGatewayApiDefinitionV4(executionContext, api)));
            }
            return apiForGatewayEvent;
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException(String.format("Failed to build API [%s] definition for gateway event", api.getId()), e);
        }
    }

    private Api buildGatewayApiDefinition(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
        Set<io.gravitee.rest.api.model.PlanEntity> plans = this.planService.findByApi(executionContext, api.getId()).stream().filter(p -> p.getStatus() != io.gravitee.rest.api.model.PlanStatus.CLOSED).collect(Collectors.toSet());
        apiDefinition.setPlans(this.planConverter.toPlansDefinitions(plans));
        apiDefinition.setFlows(this.flowService.findByReference(FlowReferenceType.API, api.getId()));
        return apiDefinition;
    }

    private AbstractApi buildGatewayApiDefinitionV4(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        if (api.getType() == ApiType.NATIVE) {
            return this.extractV4NativeApiDefinition(api);
        }
        return this.extractV4ApiDefinition(executionContext, api);
    }

    private io.gravitee.definition.model.v4.Api extractV4ApiDefinition(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = (io.gravitee.definition.model.v4.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.v4.Api.class);
        Set<PlanEntity> plans = this.planServiceV4.findByApi(executionContext, api.getId()).stream().filter(p -> p.getPlanStatus() != PlanStatus.CLOSED).collect(Collectors.toSet());
        apiDefinitionV4.setPlans(this.planMapper.toDefinitions(plans));
        apiDefinitionV4.setFlows(this.flowServiceV4.findByReference(FlowReferenceType.API, api.getId()));
        return apiDefinitionV4;
    }

    private NativeApi extractV4NativeApiDefinition(io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        NativeApi apiDefinitionNativeV4 = (NativeApi)this.objectMapper.readValue(api.getDefinition(), NativeApi.class);
        List<NativePlan> nativePlans = this.planQueryService.findAllByApiId(api.getId()).stream().filter(p -> p.getPlanStatus() != PlanStatus.CLOSED && p.getPlanDefinitionNativeV4() != null).map(p -> {
            p.getPlanDefinitionNativeV4().setFlows(this.flowCrudService.getNativePlanFlows(p.getId()));
            return p.getPlanDefinitionNativeV4();
        }).toList();
        apiDefinitionNativeV4.setPlans(nativePlans);
        apiDefinitionNativeV4.setFlows(this.flowCrudService.getNativeApiFlows(api.getId()));
        return apiDefinitionNativeV4;
    }

    @Override
    public void createOrPatchLatestEvent(String latestEventId, String organizationId, EventEntity event) {
        Event latestEvent = this.convert(event);
        latestEvent.setId(latestEventId);
        latestEvent.setOrganizations(Set.of(organizationId));
        if (latestEvent.getProperties() == null) {
            latestEvent.setProperties(new HashMap());
        }
        latestEvent.getProperties().put(Event.EventProperties.ID.getValue(), event.getId());
        try {
            this.LOGGER.debug("Create or Update latest event {}.", (Object)latestEventId);
            this.eventLatestRepository.createOrUpdate(latestEvent);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying create or patch " + String.valueOf(latestEvent), ex);
        }
    }

    private Event convert(EventEntity eventEntity) {
        Event event = new Event();
        event.setId(eventEntity.getId());
        event.setParentId(eventEntity.getParentId());
        event.setEnvironments(eventEntity.getEnvironments());
        event.setType(EventType.valueOf((String)eventEntity.getType().toString()));
        event.setPayload(eventEntity.getPayload());
        event.setProperties(new HashMap(eventEntity.getProperties()));
        event.setCreatedAt(eventEntity.getCreatedAt());
        event.setUpdatedAt(eventEntity.getUpdatedAt());
        return event;
    }
}

