/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.Sortable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.repository.management.model.User;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiPrimaryOwnerRemovalUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiPrimaryOwnerRemovalUpgrader.class);
    private final RoleRepository roleRepository;
    private final ApiRepository apiRepository;
    private final MembershipRepository membershipRepository;
    private final OrganizationRepository organizationRepository;
    private final EnvironmentRepository environmentRepository;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;
    @Value(value="${services.api-primary-owner-default:}")
    private String defaultPrimaryOwnerId;

    public ApiPrimaryOwnerRemovalUpgrader(@Lazy RoleRepository roleRepository, @Lazy ApiRepository apiRepository, @Lazy MembershipRepository membershipRepository, @Lazy OrganizationRepository organizationRepository, @Lazy EnvironmentRepository environmentRepository, @Lazy UserRepository userRepository, @Lazy GroupRepository groupRepository) {
        this.roleRepository = roleRepository;
        this.apiRepository = apiRepository;
        this.membershipRepository = membershipRepository;
        this.organizationRepository = organizationRepository;
        this.environmentRepository = environmentRepository;
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(() -> {
            Set organizations = this.organizationRepository.findAll();
            for (Organization org : organizations) {
                if (this.checkOrganization(org.getId())) continue;
                return false;
            }
            return true;
        });
    }

    private boolean checkOrganization(String organizationId) throws TechnicalException {
        String apiPrimaryOwnerRoleId = this.findApiPrimaryOwnerRoleId(organizationId);
        List<String> environmentIds = this.findEnvironmentIds(organizationId);
        ArrayList<String> corruptedApiIds = new ArrayList<String>();
        int page = 0;
        int size = 100;
        Pageable pageable = new PageableBuilder().pageNumber(page).pageSize(size).build();
        Sortable sortable = new SortableBuilder().field("updated_at").order(Order.DESC).build();
        List apiIds = this.apiRepository.searchIds(List.of(new ApiCriteria.Builder().environments(environmentIds).build()), pageable, sortable).getContent();
        while (!apiIds.isEmpty()) {
            corruptedApiIds.addAll(this.findCorruptedApiIds(apiPrimaryOwnerRoleId, apiIds));
            pageable = new PageableBuilder().pageNumber(page++).pageSize(size).build();
            apiIds = this.apiRepository.searchIds(List.of(new ApiCriteria.Builder().environments(environmentIds).build()), pageable, sortable).getContent();
        }
        if (!corruptedApiIds.isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)this.defaultPrimaryOwnerId)) {
                this.warn(corruptedApiIds);
                return false;
            }
            this.fix(corruptedApiIds, apiPrimaryOwnerRoleId);
        }
        return true;
    }

    private void warn(List<String> apiIds) {
        log.warn("");
        log.warn("##############################################################");
        log.warn("#                           WARNING                          #");
        log.warn("##############################################################");
        log.warn("");
        log.warn("The following APIs do not have a Primary Owner:");
        log.warn("");
        apiIds.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        log.warn("");
        log.warn("Please edit the services.api-primary-owner-default property of your configuration file to fix this");
        log.warn("This value must refer to a valid user or group ID");
        log.warn("");
        log.warn("##############################################################");
        log.warn("");
    }

    private void fix(List<String> apiIds, String apiPrimaryOwnerRoleId) throws TechnicalException {
        log.info("Attempting to fix APIs without a Primary Owner from configuration");
        Membership membership = this.prepareMembership(apiPrimaryOwnerRoleId);
        for (String apiId : apiIds) {
            membership.setId(UuidString.generateRandom());
            membership.setReferenceId(apiId);
            this.membershipRepository.create(membership);
        }
        String memberType = membership.getMemberType().name().toLowerCase();
        log.info("APIs without a Primary Owner has been associated with {} {}", (Object)memberType, (Object)this.defaultPrimaryOwnerId);
    }

    public int getOrder() {
        return 140;
    }

    private String findApiPrimaryOwnerRoleId(String organizationId) throws TechnicalException {
        return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), organizationId, RoleReferenceType.ORGANIZATION).map(Role::getId).orElseThrow(() -> new TechnicalException("Unable to find API Primary Owner role for organization " + organizationId));
    }

    private List<String> findEnvironmentIds(String organizationId) throws TechnicalException {
        return this.environmentRepository.findByOrganization(organizationId).stream().map(Environment::getId).collect(Collectors.toList());
    }

    private List<String> findCorruptedApiIds(String apiPrimaryOwnerRoleId, List<String> apiIds) throws TechnicalException {
        List apiIdWithPrimaryOwner = this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, apiIds, apiPrimaryOwnerRoleId).stream().map(Membership::getReferenceId).collect(Collectors.toList());
        ArrayList<String> corruptedApiIds = new ArrayList<String>(apiIds);
        corruptedApiIds.removeAll(apiIdWithPrimaryOwner);
        return corruptedApiIds;
    }

    private Membership prepareMembership(String poRoleId) throws TechnicalException {
        Optional optUser = this.userRepository.findById((Object)this.defaultPrimaryOwnerId);
        if (optUser.isPresent()) {
            User user = (User)optUser.get();
            return ApiPrimaryOwnerRemovalUpgrader.membership(user.getId(), MembershipMemberType.USER, poRoleId);
        }
        return this.groupRepository.findById((Object)this.defaultPrimaryOwnerId).map(group -> ApiPrimaryOwnerRemovalUpgrader.membership(group.getId(), MembershipMemberType.GROUP, poRoleId)).orElseThrow(() -> new TechnicalException("Unable to find a user or group with id " + this.defaultPrimaryOwnerId));
    }

    private static Membership membership(String memberId, MembershipMemberType memberType, String roleId) {
        return new Membership(null, memberId, memberType, null, MembershipReferenceType.API, roleId);
    }
}

