/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class TagNotAllowedException
extends AbstractManagementException {
    private final String tags;

    public TagNotAllowedException(String[] tags) {
        this.tags = Arrays.toString(tags);
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return String.format("You are not allowed to use deployment on the tag(s) %s.", this.tags);
    }

    @Override
    public String getTechnicalCode() {
        return "tag.notAllowed";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("tags", this.tags);
    }
}

