/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.adapter;

import io.gravitee.apim.core.cockpit.query_service.CockpitAccessService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import io.gravitee.apim.core.installation.model.InstallationType;
import io.gravitee.cockpit.api.command.model.accesspoint.AccessPoint;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.hello.HelloCommandPayload;
import io.gravitee.cockpit.api.command.v1.hello.HelloReply;
import io.gravitee.common.util.Version;
import io.gravitee.exchange.api.command.CommandAdapter;
import io.gravitee.exchange.api.command.hello.HelloCommand;
import io.gravitee.node.api.Node;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.spring.InstallationConfiguration;
import io.reactivex.rxjava3.core.Single;
import jakarta.annotation.PostConstruct;
import java.util.EnumMap;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HelloCommandAdapter
implements CommandAdapter<HelloCommand, io.gravitee.cockpit.api.command.v1.hello.HelloCommand, HelloReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelloCommandAdapter.class);
    private static final String PATH_SUFFIX = "/";
    @Value(value="${cockpit.auth.path:/auth/cockpit?token={token}}")
    protected String authPath;
    @Value(value="${cockpit.trial:false}")
    private boolean cockpitTrial;
    private final Node node;
    private final InstallationService installationService;
    private final InstallationTypeDomainService installationTypeDomainService;
    private final CockpitAccessService cockpitAccessService;
    private final PluginRegistry pluginRegistry;
    private final InstallationConfiguration configuration;
    protected String buildAuthPath;

    @PostConstruct
    public void afterPropertiesSet() {
        StringBuilder authPathBuilder = new StringBuilder(this.configuration.getManagementProxyPath());
        if (this.configuration.getManagementProxyPath().endsWith(PATH_SUFFIX) && this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(this.authPath.substring(1));
        } else if (this.configuration.getManagementProxyPath().endsWith(PATH_SUFFIX) && !this.authPath.startsWith(PATH_SUFFIX) || !this.configuration.getManagementProxyPath().endsWith(PATH_SUFFIX) && this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(this.authPath);
        } else if (!this.configuration.getManagementProxyPath().endsWith(PATH_SUFFIX) && !this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(PATH_SUFFIX).append(this.authPath);
        }
        this.buildAuthPath = authPathBuilder.toString();
    }

    public String supportType() {
        return CockpitCommandType.HELLO.name();
    }

    public Single<io.gravitee.cockpit.api.command.v1.hello.HelloCommand> adapt(String targetId, HelloCommand command) {
        return Single.fromCallable(this.installationService::getOrInitialize).map(installation -> {
            InstallationType installationType = this.installationTypeDomainService.get();
            HelloCommandPayload.HelloCommandPayloadBuilder payloadBuilder = HelloCommandPayload.builder().node(io.gravitee.cockpit.api.command.model.Node.builder().application(this.node.application()).installationId(installation.getId()).hostname(this.node.hostname()).version(Version.RUNTIME_VERSION.MAJOR_VERSION).connectorVersion(this.connectorVersion()).build()).installationType(installationType.getLabel()).trial(this.cockpitTrial).defaultOrganizationId(GraviteeContext.getDefaultOrganization()).defaultEnvironmentId(GraviteeContext.getDefaultEnvironment());
            HashMap<String, String> additionalInformation = new HashMap<String, String>(this.configuration.getAdditionalInformation());
            additionalInformation.putAll(installation.getAdditionalInformation());
            additionalInformation.put("AUTH_PATH", this.buildAuthPath);
            if (installationType == InstallationType.MULTI_TENANT) {
                EnumMap accessPointTemplates = new EnumMap(AccessPoint.Type.class);
                this.cockpitAccessService.getAccessPointsTemplate().forEach((type, accessPoints) -> accessPointTemplates.put(AccessPoint.Type.valueOf((String)type.name()), accessPoints.stream().map(accessPoint -> AccessPoint.builder().host(accessPoint.getHost()).secured(accessPoint.isSecured()).target(AccessPoint.Target.valueOf((String)accessPoint.getTarget().name())).build()).toList()));
                payloadBuilder.accessPointsTemplate(accessPointTemplates);
            } else {
                additionalInformation.put("AUTH_BASE_URL", this.configuration.getApiURL());
            }
            payloadBuilder.additionalInformation(additionalInformation);
            return new io.gravitee.cockpit.api.command.v1.hello.HelloCommand(payloadBuilder.build());
        });
    }

    private String connectorVersion() {
        try {
            return this.pluginRegistry.get("cockpit", "cockpit-connectors-ws").manifest().version();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Generated
    public HelloCommandAdapter(Node node, InstallationService installationService, InstallationTypeDomainService installationTypeDomainService, CockpitAccessService cockpitAccessService, PluginRegistry pluginRegistry, InstallationConfiguration configuration) {
        this.node = node;
        this.installationService = installationService;
        this.installationTypeDomainService = installationTypeDomainService;
        this.cockpitAccessService = cockpitAccessService;
        this.pluginRegistry = pluginRegistry;
        this.configuration = configuration;
    }
}

