/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.shared_policy_group;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.exception.SharedPolicyGroupNotFoundException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupHistoryQueryService;
import io.gravitee.apim.infra.adapter.SharedPolicyGroupAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SharedPolicyGroupRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SharedPolicyGroupCrudServiceImpl
implements SharedPolicyGroupCrudService {
    private final SharedPolicyGroupRepository sharedPolicyGroupRepository;
    private final SharedPolicyGroupAdapter sharedPolicyGroupAdapter;
    private final SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService;

    public SharedPolicyGroupCrudServiceImpl(@Lazy SharedPolicyGroupRepository sharedPolicyGroupRepository, SharedPolicyGroupAdapter sharedPolicyGroupAdapter, SharedPolicyGroupHistoryQueryService sharedPolicyGroupHistoryQueryService) {
        this.sharedPolicyGroupRepository = sharedPolicyGroupRepository;
        this.sharedPolicyGroupAdapter = sharedPolicyGroupAdapter;
        this.sharedPolicyGroupHistoryQueryService = sharedPolicyGroupHistoryQueryService;
    }

    @Override
    public SharedPolicyGroup create(SharedPolicyGroup sharedPolicyGroupEntity) {
        try {
            io.gravitee.repository.management.model.SharedPolicyGroup result = (io.gravitee.repository.management.model.SharedPolicyGroup)this.sharedPolicyGroupRepository.create((Object)this.sharedPolicyGroupAdapter.fromEntity(sharedPolicyGroupEntity));
            return this.sharedPolicyGroupAdapter.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a SharedPolicyGroup with id: %s", sharedPolicyGroupEntity.getId()), e);
        }
    }

    @Override
    public SharedPolicyGroup getByEnvironmentId(String environmentId, String sharedPolicyGroupId) {
        try {
            return this.sharedPolicyGroupRepository.findById((Object)sharedPolicyGroupId).filter(SharedPolicyGroupCrudServiceImpl.belongsToEnvironment(environmentId)).map(this.sharedPolicyGroupAdapter::toEntity).orElseThrow(() -> new SharedPolicyGroupNotFoundException(sharedPolicyGroupId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a SharedPolicyGroup with id: %s", sharedPolicyGroupId), e);
        }
    }

    @NotNull
    private static Predicate<io.gravitee.repository.management.model.SharedPolicyGroup> belongsToEnvironment(String environmentId) {
        return sharedPolicyGroup -> environmentId.equals(sharedPolicyGroup.getEnvironmentId());
    }

    @Override
    public SharedPolicyGroup update(SharedPolicyGroup sharedPolicyGroupEntity) {
        try {
            io.gravitee.repository.management.model.SharedPolicyGroup result = (io.gravitee.repository.management.model.SharedPolicyGroup)this.sharedPolicyGroupRepository.update((Object)this.sharedPolicyGroupAdapter.fromEntity(sharedPolicyGroupEntity));
            return this.sharedPolicyGroupAdapter.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update the SharedPolicyGroup with id: %s", sharedPolicyGroupEntity.getId()), e);
        }
    }

    @Override
    public void delete(String sharedPolicyGroupId) {
        try {
            this.sharedPolicyGroupRepository.delete((Object)sharedPolicyGroupId);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to delete the SharedPolicyGroup with id: %s", sharedPolicyGroupId), e);
        }
    }

    @Override
    public Optional<SharedPolicyGroup> findByEnvironmentIdAndCrossId(String environmentId, String crossId) {
        try {
            return this.sharedPolicyGroupRepository.findByEnvironmentIdAndCrossId(environmentId, crossId).map(this.sharedPolicyGroupAdapter::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a SharedPolicyGroup with environmentId: %s and crossId: %s", environmentId, crossId), e);
        }
    }

    @Override
    public Optional<SharedPolicyGroup> getLastDeployedByEnvironmentIdAndCrossId(String environmentId, String crossId) {
        try {
            Optional sharedPolicyGroupOpt = this.sharedPolicyGroupRepository.findByEnvironmentIdAndCrossId(environmentId, crossId);
            if (sharedPolicyGroupOpt.isPresent()) {
                io.gravitee.repository.management.model.SharedPolicyGroup sharedPolicyGroup = (io.gravitee.repository.management.model.SharedPolicyGroup)sharedPolicyGroupOpt.get();
                if (sharedPolicyGroup.isDeployed()) {
                    return sharedPolicyGroupOpt.map(this.sharedPolicyGroupAdapter::toEntity);
                }
                Optional<SharedPolicyGroup> historySharedPolicyGroupOpt = this.sharedPolicyGroupHistoryQueryService.getLatestBySharedPolicyGroupId(environmentId, sharedPolicyGroup.getId());
                if (historySharedPolicyGroupOpt.isPresent()) {
                    return historySharedPolicyGroupOpt;
                }
            }
            return Optional.empty();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find the last deployed SharedPolicyGroup with environmentId: %s and crossId: %s", environmentId, crossId), e);
        }
    }
}

