/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.apim.infra.adapter.AuditAdapter;
import io.gravitee.repository.management.model.Audit;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class AuditAdapterImpl
implements AuditAdapter {
    @Override
    public AuditEntity toEntity(Audit source) {
        if (source == null) {
            return null;
        }
        AuditEntity.AuditEntityBuilder auditEntity = AuditEntity.builder();
        auditEntity.id(source.getId());
        auditEntity.organizationId(source.getOrganizationId());
        auditEntity.environmentId(source.getEnvironmentId());
        auditEntity.referenceType(this.auditReferenceTypeToAuditReferenceType(source.getReferenceType()));
        auditEntity.referenceId(source.getReferenceId());
        auditEntity.user(source.getUser());
        Map map = source.getProperties();
        if (map != null) {
            auditEntity.properties(new LinkedHashMap<String, String>(map));
        }
        auditEntity.event(source.getEvent());
        if (source.getCreatedAt() != null) {
            auditEntity.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        auditEntity.patch(source.getPatch());
        return auditEntity.build();
    }

    protected AuditEntity.AuditReferenceType auditReferenceTypeToAuditReferenceType(Audit.AuditReferenceType auditReferenceType) {
        if (auditReferenceType == null) {
            return null;
        }
        return switch (auditReferenceType) {
            case Audit.AuditReferenceType.API -> AuditEntity.AuditReferenceType.API;
            case Audit.AuditReferenceType.APPLICATION -> AuditEntity.AuditReferenceType.APPLICATION;
            case Audit.AuditReferenceType.ENVIRONMENT -> AuditEntity.AuditReferenceType.ENVIRONMENT;
            case Audit.AuditReferenceType.ORGANIZATION -> AuditEntity.AuditReferenceType.ORGANIZATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(auditReferenceType));
        };
    }
}

