/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.ApiServicesCRD;
import io.gravitee.apim.core.api.model.property.EncryptableProperty;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.federation.FederatedAgent;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.AbstractEndpoint;
import io.gravitee.definition.model.v4.endpointgroup.AbstractEndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.failover.Failover;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativeApiServices;
import io.gravitee.definition.model.v4.nativeapi.NativeEndpointGroup;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.nativeapi.NativeListener;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.ApiServices;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiAgentEntity;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.api.properties.PropertyEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ApiAdapterImpl_
implements ApiAdapter {
    private final PlanAdapter planAdapter = PlanAdapter.INSTANCE;

    @Override
    public Api toCoreModel(io.gravitee.repository.management.model.Api source) {
        List list;
        Set set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder<?, ?> api = Api.builder();
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.hrid(source.getHrid());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(source.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.apiDefinitionHttpV4(this.deserializeApiDefinitionV4(source));
        api.apiDefinition(this.deserializeApiDefinitionV2(source));
        api.federatedApiDefinition(this.deserializeFederatedApiDefinition(source));
        api.apiDefinitionNativeV4(this.deserializeNativeApiDefinition(source));
        return api.build();
    }

    @Override
    public Stream<Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toCoreModel((io.gravitee.repository.management.model.Api)api));
    }

    @Override
    public io.gravitee.repository.management.model.Api toRepository(Api source) {
        List<String> list;
        Set<String> set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = io.gravitee.repository.management.model.Api.builder();
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.hrid(source.getHrid());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(Date.from(source.getDeployedAt().toInstant()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        api.visibility(this.visibilityToVisibility1(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState1(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set<String> set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState1(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.definition(this.serializeApiDefinition(source));
        return api.build();
    }

    @Override
    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toRepository((Api)api));
    }

    @Override
    public NewApiEntity toNewApiEntity(Api source) {
        List<Flow> flows;
        List<EndpointGroup> endpointGroups;
        List<EndpointGroup> list1;
        List<Listener> listeners;
        List<Listener> list;
        Set<String> tags;
        if (source == null) {
            return null;
        }
        NewApiEntity newApiEntity = new NewApiEntity();
        newApiEntity.setApiVersion(source.getVersion());
        Set<String> set = tags = this.sourceApiDefinitionHttpV4Tags(source);
        if (set != null) {
            newApiEntity.setTags(new LinkedHashSet<String>(set));
        }
        if ((list = (listeners = this.sourceApiDefinitionHttpV4Listeners(source))) != null) {
            newApiEntity.setListeners(new ArrayList<Listener>(list));
        }
        if ((list1 = (endpointGroups = this.sourceApiDefinitionHttpV4EndpointGroups(source))) != null) {
            newApiEntity.setEndpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        newApiEntity.setAnalytics(this.sourceApiDefinitionHttpV4Analytics(source));
        newApiEntity.setFlowExecution(this.sourceApiDefinitionHttpV4FlowExecution(source));
        List<Flow> list2 = flows = this.sourceApiDefinitionHttpV4Flows(source);
        if (list2 != null) {
            newApiEntity.setFlows(new ArrayList<Flow>(list2));
        }
        newApiEntity.setFailover(this.sourceApiDefinitionHttpV4Failover(source));
        newApiEntity.setName(source.getName());
        newApiEntity.setDescription(source.getDescription());
        newApiEntity.setDefinitionVersion(source.getDefinitionVersion());
        newApiEntity.setType(source.getType());
        Set<String> set1 = source.getGroups();
        if (set1 != null) {
            newApiEntity.setGroups(new LinkedHashSet<String>(set1));
        }
        return newApiEntity;
    }

    @Override
    public UpdateApiEntity toUpdateApiEntity(ApiCRDSpec spec) {
        Set<String> set4;
        Set<String> set3;
        Set<String> set;
        if (spec == null) {
            return null;
        }
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setApiVersion(spec.getVersion());
        updateApiEntity.setName(spec.getName());
        updateApiEntity.setDescription(spec.getDescription());
        updateApiEntity.setId(spec.getId());
        updateApiEntity.setCrossId(spec.getCrossId());
        updateApiEntity.setHrid(spec.getHrid());
        if (spec.getDefinitionVersion() != null) {
            updateApiEntity.setDefinitionVersion(Enum.valueOf(DefinitionVersion.class, spec.getDefinitionVersion()));
        }
        if (spec.getType() != null) {
            updateApiEntity.setType(Enum.valueOf(ApiType.class, spec.getType()));
        }
        if ((set = spec.getTags()) != null) {
            updateApiEntity.setTags(new LinkedHashSet<String>(set));
        }
        updateApiEntity.setAnalytics(spec.getAnalytics());
        updateApiEntity.setFailover(spec.getFailover());
        updateApiEntity.setProperties(this.encryptablePropertyListToPropertyEntityList(spec.getProperties()));
        List<Resource> list1 = spec.getResources();
        if (list1 != null) {
            updateApiEntity.setResources(new ArrayList<Resource>(list1));
        }
        updateApiEntity.setPlans(this.planAdapter.toPlanEntityV4(spec.getPlans()));
        updateApiEntity.setFlowExecution(spec.getFlowExecution());
        Map<String, Map<String, ResponseTemplate>> map = spec.getResponseTemplates();
        if (map != null) {
            updateApiEntity.setResponseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        updateApiEntity.setServices(this.apiServicesCRDToApiServices(spec.getServices()));
        Set<String> set2 = spec.getGroups();
        if (set2 != null) {
            updateApiEntity.setGroups(new LinkedHashSet<String>(set2));
        }
        if (spec.getVisibility() != null) {
            updateApiEntity.setVisibility(Enum.valueOf(Visibility.class, spec.getVisibility()));
        }
        if ((set3 = spec.getCategories()) != null) {
            updateApiEntity.setCategories(new LinkedHashSet<String>(set3));
        }
        if ((set4 = spec.getLabels()) != null) {
            updateApiEntity.setLabels(new ArrayList<String>(set4));
        }
        updateApiEntity.setMetadata(this.apiMetadataListToApiMetadataEntityList(spec.getMetadata()));
        if (spec.getLifecycleState() != null) {
            updateApiEntity.setLifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, spec.getLifecycleState()));
        }
        updateApiEntity.setDisableMembershipNotifications(!spec.isNotifyMembers());
        updateApiEntity.setListeners(spec.getListeners());
        updateApiEntity.setEndpointGroups(spec.getEndpointGroups());
        updateApiEntity.setFlows(spec.getFlows());
        return updateApiEntity;
    }

    @Override
    public UpdateApiEntity toUpdateApiEntity(Api api, io.gravitee.definition.model.v4.Api apiDefinitionV4) {
        if (api == null && apiDefinitionV4 == null) {
            return null;
        }
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        if (api != null) {
            List<String> list5;
            updateApiEntity.setId(api.getId());
            updateApiEntity.setName(api.getName());
            updateApiEntity.setDefinitionVersion(api.getDefinitionVersion());
            updateApiEntity.setType(api.getType());
            Set<String> set = api.getTags();
            if (set != null) {
                updateApiEntity.setTags(new LinkedHashSet<String>(set));
            }
            updateApiEntity.setApiVersion(api.getVersion());
            updateApiEntity.setLifecycleState(this.apiLifecycleStateToApiLifecycleState2(api.getApiLifecycleState()));
            updateApiEntity.setDescription(api.getDescription());
            updateApiEntity.setCrossId(api.getCrossId());
            updateApiEntity.setHrid(api.getHrid());
            Set<String> set2 = api.getGroups();
            if (set2 != null) {
                updateApiEntity.setGroups(new LinkedHashSet<String>(set2));
            }
            updateApiEntity.setVisibility(this.visibilityToVisibility2(api.getVisibility()));
            updateApiEntity.setPicture(api.getPicture());
            Set<String> set3 = api.getCategories();
            if (set3 != null) {
                updateApiEntity.setCategories(new LinkedHashSet<String>(set3));
            }
            if ((list5 = api.getLabels()) != null) {
                updateApiEntity.setLabels(new ArrayList<String>(list5));
            }
            updateApiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
            updateApiEntity.setBackground(api.getBackground());
        }
        if (apiDefinitionV4 != null) {
            Map map;
            List list1;
            List list = apiDefinitionV4.getListeners();
            if (list != null) {
                updateApiEntity.setListeners(new ArrayList(list));
            }
            if ((list1 = apiDefinitionV4.getEndpointGroups()) != null) {
                updateApiEntity.setEndpointGroups(new ArrayList(list1));
            }
            updateApiEntity.setAnalytics(apiDefinitionV4.getAnalytics());
            updateApiEntity.setFailover(apiDefinitionV4.getFailover());
            updateApiEntity.setProperties(this.propertyListToPropertyEntityList(apiDefinitionV4.getProperties()));
            List list3 = apiDefinitionV4.getResources();
            if (list3 != null) {
                updateApiEntity.setResources(new ArrayList(list3));
            }
            updateApiEntity.setPlans(this.planListToPlanEntitySet(apiDefinitionV4.getPlans()));
            updateApiEntity.setFlowExecution(apiDefinitionV4.getFlowExecution());
            List list4 = apiDefinitionV4.getFlows();
            if (list4 != null) {
                updateApiEntity.setFlows(new ArrayList(list4));
            }
            if ((map = apiDefinitionV4.getResponseTemplates()) != null) {
                updateApiEntity.setResponseTemplates(new LinkedHashMap(map));
            }
            updateApiEntity.setServices(apiDefinitionV4.getServices());
        }
        return updateApiEntity;
    }

    @Override
    public ApiEntity toApiEntity(ApiCRDSpec api) {
        Set<String> set4;
        Set<String> set3;
        if (api == null) {
            return null;
        }
        ApiEntity.ApiEntityBuilder apiEntity = ApiEntity.builder();
        apiEntity.apiVersion(api.getVersion());
        apiEntity.id(api.getId());
        apiEntity.crossId(api.getCrossId());
        apiEntity.hrid(api.getHrid());
        apiEntity.name(api.getName());
        if (api.getDefinitionVersion() != null) {
            apiEntity.definitionVersion(Enum.valueOf(DefinitionVersion.class, api.getDefinitionVersion()));
        }
        if (api.getType() != null) {
            apiEntity.type(Enum.valueOf(ApiType.class, api.getType()));
        }
        apiEntity.description(api.getDescription());
        Set<String> set = api.getTags();
        if (set != null) {
            apiEntity.tags(new LinkedHashSet<String>(set));
        }
        apiEntity.endpointGroups(this.abstractEndpointGroupListToEndpointGroupList(api.getEndpointGroups()));
        apiEntity.analytics(api.getAnalytics());
        apiEntity.failover(api.getFailover());
        apiEntity.properties(this.encryptablePropertyListToPropertyList(api.getProperties()));
        List<Resource> list2 = api.getResources();
        if (list2 != null) {
            apiEntity.resources(new ArrayList<Resource>(list2));
        }
        apiEntity.plans(this.planAdapter.toPlanEntityV4(api.getPlans()));
        apiEntity.flowExecution(api.getFlowExecution());
        apiEntity.flows(this.abstractFlowListToFlowList(api.getFlows()));
        Map<String, Map<String, ResponseTemplate>> map = api.getResponseTemplates();
        if (map != null) {
            apiEntity.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        apiEntity.services(this.apiServicesCRDToApiServices(api.getServices()));
        Set<String> set2 = api.getGroups();
        if (set2 != null) {
            apiEntity.groups(new LinkedHashSet<String>(set2));
        }
        if (api.getVisibility() != null) {
            apiEntity.visibility(Enum.valueOf(Visibility.class, api.getVisibility()));
        }
        if (api.getState() != null) {
            apiEntity.state(Enum.valueOf(Lifecycle.State.class, api.getState()));
        }
        if ((set3 = api.getCategories()) != null) {
            apiEntity.categories(new LinkedHashSet<String>(set3));
        }
        if ((set4 = api.getLabels()) != null) {
            apiEntity.labels(new ArrayList<String>(set4));
        }
        if (api.getLifecycleState() != null) {
            apiEntity.lifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, api.getLifecycleState()));
        }
        apiEntity.listeners(api.getListeners());
        return apiEntity.build();
    }

    @Override
    public ApiEntity toApiEntity(Api api) {
        List<String> list;
        Set<String> set1;
        if (api == null) {
            return null;
        }
        ApiEntity.ApiEntityBuilder apiEntity = ApiEntity.builder();
        apiEntity.apiVersion(api.getVersion());
        apiEntity.id(api.getId());
        apiEntity.crossId(api.getCrossId());
        apiEntity.hrid(api.getHrid());
        apiEntity.name(api.getName());
        apiEntity.definitionVersion(api.getDefinitionVersion());
        apiEntity.type(api.getType());
        if (api.getDeployedAt() != null) {
            apiEntity.deployedAt(Date.from(api.getDeployedAt().toInstant()));
        }
        if (api.getCreatedAt() != null) {
            apiEntity.createdAt(Date.from(api.getCreatedAt().toInstant()));
        }
        if (api.getUpdatedAt() != null) {
            apiEntity.updatedAt(Date.from(api.getUpdatedAt().toInstant()));
        }
        apiEntity.description(api.getDescription());
        Set<String> set = api.getTags();
        if (set != null) {
            apiEntity.tags(new LinkedHashSet<String>(set));
        }
        if ((set1 = api.getGroups()) != null) {
            apiEntity.groups(new LinkedHashSet<String>(set1));
        }
        apiEntity.visibility(this.visibilityToVisibility2(api.getVisibility()));
        apiEntity.picture(api.getPicture());
        Set<String> set2 = api.getCategories();
        if (set2 != null) {
            apiEntity.categories(new LinkedHashSet<String>(set2));
        }
        if ((list = api.getLabels()) != null) {
            apiEntity.labels(new ArrayList<String>(list));
        }
        apiEntity.originContext(api.getOriginContext());
        apiEntity.lifecycleState(this.lifecycleStateToApiLifecycleState(api.getLifecycleState()));
        apiEntity.disableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.background(api.getBackground());
        apiEntity.listeners(api.getApiListeners());
        return apiEntity.build();
    }

    @Override
    public NativeApiEntity toNativeApiEntity(Api api) {
        List<String> list5;
        List<Property> properties;
        List<Resource> resources;
        List<Resource> list3;
        List<NativeFlow> flows;
        List<NativeFlow> list2;
        List<NativeEndpointGroup> endpointGroups;
        List<NativeEndpointGroup> list1;
        List<NativeListener> listeners;
        List<NativeListener> list;
        Set<String> tags;
        if (api == null) {
            return null;
        }
        NativeApiEntity.NativeApiEntityBuilder nativeApiEntity = NativeApiEntity.builder();
        nativeApiEntity.apiVersion(api.getVersion());
        Set<String> set = tags = this.apiApiDefinitionNativeV4Tags(api);
        if (set != null) {
            nativeApiEntity.tags(new LinkedHashSet<String>(set));
        }
        if ((list = (listeners = this.apiApiDefinitionNativeV4Listeners(api))) != null) {
            nativeApiEntity.listeners(new ArrayList<NativeListener>(list));
        }
        if ((list1 = (endpointGroups = this.apiApiDefinitionNativeV4EndpointGroups(api))) != null) {
            nativeApiEntity.endpointGroups(new ArrayList<NativeEndpointGroup>(list1));
        }
        if ((list2 = (flows = this.apiApiDefinitionNativeV4Flows(api))) != null) {
            nativeApiEntity.flows(new ArrayList<NativeFlow>(list2));
        }
        if ((list3 = (resources = this.apiApiDefinitionNativeV4Resources(api))) != null) {
            nativeApiEntity.resources(new ArrayList<Resource>(list3));
        }
        nativeApiEntity.services(this.apiApiDefinitionNativeV4Services(api));
        List<Property> list4 = properties = this.apiApiDefinitionNativeV4Properties(api);
        if (list4 != null) {
            nativeApiEntity.properties(new ArrayList<Property>(list4));
        }
        nativeApiEntity.state(this.lifecycleStateToState(api.getLifecycleState()));
        nativeApiEntity.lifecycleState(this.apiLifecycleStateToApiLifecycleState2(api.getApiLifecycleState()));
        nativeApiEntity.id(api.getId());
        nativeApiEntity.crossId(api.getCrossId());
        nativeApiEntity.hrid(api.getHrid());
        nativeApiEntity.name(api.getName());
        nativeApiEntity.definitionVersion(api.getDefinitionVersion());
        nativeApiEntity.type(api.getType());
        if (api.getDeployedAt() != null) {
            nativeApiEntity.deployedAt(Date.from(api.getDeployedAt().toInstant()));
        }
        if (api.getCreatedAt() != null) {
            nativeApiEntity.createdAt(Date.from(api.getCreatedAt().toInstant()));
        }
        if (api.getUpdatedAt() != null) {
            nativeApiEntity.updatedAt(Date.from(api.getUpdatedAt().toInstant()));
        }
        nativeApiEntity.description(api.getDescription());
        Set<String> set1 = api.getGroups();
        if (set1 != null) {
            nativeApiEntity.groups(new LinkedHashSet<String>(set1));
        }
        nativeApiEntity.visibility(this.visibilityToVisibility2(api.getVisibility()));
        nativeApiEntity.picture(api.getPicture());
        Set<String> set2 = api.getCategories();
        if (set2 != null) {
            nativeApiEntity.categories(new LinkedHashSet<String>(set2));
        }
        if ((list5 = api.getLabels()) != null) {
            nativeApiEntity.labels(new ArrayList<String>(list5));
        }
        nativeApiEntity.originContext(api.getOriginContext());
        nativeApiEntity.disableMembershipNotifications(api.isDisableMembershipNotifications());
        nativeApiEntity.background(api.getBackground());
        return nativeApiEntity.build();
    }

    @Override
    public FederatedApiEntity toFederatedApiEntity(io.gravitee.repository.management.model.Api source, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwnerEntity) {
        if (source == null && primaryOwnerEntity == null) {
            return null;
        }
        FederatedApiEntity.FederatedApiEntityBuilder federatedApiEntity = FederatedApiEntity.builder();
        if (source != null) {
            List list;
            federatedApiEntity.apiVersion(source.getVersion());
            federatedApiEntity.id(source.getId());
            federatedApiEntity.referenceId(source.getEnvironmentId());
            federatedApiEntity.lifecycleState(this.apiLifecycleStateToApiLifecycleState3(source.getApiLifecycleState()));
            federatedApiEntity.crossId(source.getCrossId());
            federatedApiEntity.name(source.getName());
            federatedApiEntity.definitionVersion(source.getDefinitionVersion());
            federatedApiEntity.deployedAt(source.getDeployedAt());
            federatedApiEntity.createdAt(source.getCreatedAt());
            federatedApiEntity.updatedAt(source.getUpdatedAt());
            federatedApiEntity.description(source.getDescription());
            Set set = source.getGroups();
            if (set != null) {
                federatedApiEntity.groups(new LinkedHashSet(set));
            }
            federatedApiEntity.visibility(this.visibilityToVisibility3(source.getVisibility()));
            federatedApiEntity.picture(source.getPicture());
            Set set1 = source.getCategories();
            if (set1 != null) {
                federatedApiEntity.categories(new LinkedHashSet(set1));
            }
            if ((list = source.getLabels()) != null) {
                federatedApiEntity.labels(new ArrayList(list));
            }
            federatedApiEntity.disableMembershipNotifications(source.isDisableMembershipNotifications());
            federatedApiEntity.background(source.getBackground());
        }
        federatedApiEntity.primaryOwner(this.primaryOwnerEntityToPrimaryOwnerEntity(primaryOwnerEntity));
        federatedApiEntity.referenceType("ENVIRONMENT");
        return federatedApiEntity.build();
    }

    @Override
    public FederatedApiAgentEntity toFederatedAgentEntity(io.gravitee.repository.management.model.Api source, FederatedAgent agent, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwnerEntity, OriginContext.Integration originContext) {
        if (source == null && agent == null && primaryOwnerEntity == null && originContext == null) {
            return null;
        }
        FederatedApiAgentEntity.FederatedApiAgentEntityBuilder federatedApiAgentEntity = FederatedApiAgentEntity.builder();
        if (source != null) {
            List list;
            federatedApiAgentEntity.apiVersion(source.getVersion());
            federatedApiAgentEntity.id(source.getId());
            federatedApiAgentEntity.referenceId(source.getEnvironmentId());
            federatedApiAgentEntity.lifecycleState(this.apiLifecycleStateToApiLifecycleState3(source.getApiLifecycleState()));
            federatedApiAgentEntity.name(source.getName());
            federatedApiAgentEntity.definitionVersion(source.getDefinitionVersion());
            federatedApiAgentEntity.description(source.getDescription());
            federatedApiAgentEntity.crossId(source.getCrossId());
            federatedApiAgentEntity.deployedAt(source.getDeployedAt());
            federatedApiAgentEntity.createdAt(source.getCreatedAt());
            federatedApiAgentEntity.updatedAt(source.getUpdatedAt());
            Set set = source.getGroups();
            if (set != null) {
                federatedApiAgentEntity.groups(new LinkedHashSet(set));
            }
            federatedApiAgentEntity.visibility(this.visibilityToVisibility3(source.getVisibility()));
            federatedApiAgentEntity.picture(source.getPicture());
            Set set1 = source.getCategories();
            if (set1 != null) {
                federatedApiAgentEntity.categories(new LinkedHashSet(set1));
            }
            if ((list = source.getLabels()) != null) {
                federatedApiAgentEntity.labels(new ArrayList(list));
            }
            federatedApiAgentEntity.disableMembershipNotifications(source.isDisableMembershipNotifications());
            federatedApiAgentEntity.background(source.getBackground());
        }
        if (agent != null) {
            Collection collection1;
            federatedApiAgentEntity.provider(this.providerToProvider(agent.getProvider()));
            Collection collection = agent.getDefaultInputModes();
            if (collection != null) {
                federatedApiAgentEntity.defaultInputModes(new ArrayList(collection));
            }
            if ((collection1 = agent.getDefaultOutputModes()) != null) {
                federatedApiAgentEntity.defaultOutputModes(new ArrayList(collection1));
            }
            federatedApiAgentEntity.skills(this.skillCollectionToSkillCollection(agent.getSkills()));
            federatedApiAgentEntity.securitySchemes(agent.getSecuritySchemes());
            federatedApiAgentEntity.security(agent.getSecurity());
            federatedApiAgentEntity.url(agent.getUrl());
            federatedApiAgentEntity.documentationUrl(agent.getDocumentationUrl());
        }
        if (originContext != null) {
            federatedApiAgentEntity.originContext(originContext);
            federatedApiAgentEntity.integrationName(originContext.integrationName());
        }
        federatedApiAgentEntity.primaryOwner(this.primaryOwnerEntityToPrimaryOwnerEntity(primaryOwnerEntity));
        federatedApiAgentEntity.referenceType("ENVIRONMENT");
        federatedApiAgentEntity.capabilities(this.capabilities(agent));
        return federatedApiAgentEntity.build();
    }

    @Override
    public Api fromApiEntity(GenericApiEntity apiEntity) {
        List list;
        Set set1;
        if (apiEntity == null) {
            return null;
        }
        Api.ApiBuilder<?, ?> api = Api.builder();
        api.lifecycleState(this.stateToLifecycleState(apiEntity.getState()));
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState4(apiEntity.getLifecycleState()));
        api.id(apiEntity.getId());
        api.name(apiEntity.getName());
        api.description(apiEntity.getDescription());
        api.originContext(apiEntity.getOriginContext());
        api.definitionVersion(apiEntity.getDefinitionVersion());
        if (apiEntity.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(apiEntity.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(apiEntity.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(apiEntity.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility4(apiEntity.getVisibility()));
        api.picture(apiEntity.getPicture());
        Set set = apiEntity.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = apiEntity.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = apiEntity.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        api.background(apiEntity.getBackground());
        return api.build();
    }

    protected Api.Visibility visibilityToVisibility(io.gravitee.repository.management.model.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case io.gravitee.repository.management.model.Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case io.gravitee.repository.management.model.Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(visibility));
        };
    }

    protected Api.LifecycleState lifecycleStateToLifecycleState(LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case LifecycleState.STARTED -> Api.LifecycleState.STARTED;
            case LifecycleState.STOPPED -> Api.LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(lifecycleState));
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(apiLifecycleState));
        };
    }

    protected io.gravitee.repository.management.model.Visibility visibilityToVisibility1(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> io.gravitee.repository.management.model.Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> io.gravitee.repository.management.model.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)visibility));
        };
    }

    protected LifecycleState lifecycleStateToLifecycleState1(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case Api.LifecycleState.STARTED -> LifecycleState.STARTED;
            case Api.LifecycleState.STOPPED -> LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)lifecycleState));
        };
    }

    protected ApiLifecycleState apiLifecycleStateToApiLifecycleState1(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)apiLifecycleState));
        };
    }

    private Set<String> sourceApiDefinitionHttpV4Tags(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getTags();
    }

    private List<Listener> sourceApiDefinitionHttpV4Listeners(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getListeners();
    }

    private List<EndpointGroup> sourceApiDefinitionHttpV4EndpointGroups(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getEndpointGroups();
    }

    private Analytics sourceApiDefinitionHttpV4Analytics(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getAnalytics();
    }

    private FlowExecution sourceApiDefinitionHttpV4FlowExecution(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getFlowExecution();
    }

    private List<Flow> sourceApiDefinitionHttpV4Flows(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getFlows();
    }

    private Failover sourceApiDefinitionHttpV4Failover(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getFailover();
    }

    protected PropertyEntity encryptablePropertyToPropertyEntity(EncryptableProperty encryptableProperty) {
        if (encryptableProperty == null) {
            return null;
        }
        PropertyEntity.PropertyEntityBuilder propertyEntity = PropertyEntity.builder();
        propertyEntity.key(encryptableProperty.getKey());
        propertyEntity.value(encryptableProperty.getValue());
        propertyEntity.encrypted(encryptableProperty.isEncrypted());
        propertyEntity.dynamic(encryptableProperty.isDynamic());
        propertyEntity.encryptable(encryptableProperty.isEncryptable());
        return propertyEntity.build();
    }

    protected List<PropertyEntity> encryptablePropertyListToPropertyEntityList(List<EncryptableProperty> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PropertyEntity> list1 = new ArrayList<PropertyEntity>(list.size());
        for (EncryptableProperty encryptableProperty : list) {
            list1.add(this.encryptablePropertyToPropertyEntity(encryptableProperty));
        }
        return list1;
    }

    protected ApiServices apiServicesCRDToApiServices(ApiServicesCRD apiServicesCRD) {
        if (apiServicesCRD == null) {
            return null;
        }
        ApiServices.ApiServicesBuilder apiServices = ApiServices.builder();
        apiServices.dynamicProperty(apiServicesCRD.getDynamicProperty());
        return apiServices.build();
    }

    protected MetadataFormat metadataFormatToMetadataFormat(Metadata.MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case Metadata.MetadataFormat.STRING -> MetadataFormat.STRING;
            case Metadata.MetadataFormat.NUMERIC -> MetadataFormat.NUMERIC;
            case Metadata.MetadataFormat.BOOLEAN -> MetadataFormat.BOOLEAN;
            case Metadata.MetadataFormat.DATE -> MetadataFormat.DATE;
            case Metadata.MetadataFormat.MAIL -> MetadataFormat.MAIL;
            case Metadata.MetadataFormat.URL -> MetadataFormat.URL;
            default -> null;
        };
    }

    protected ApiMetadataEntity apiMetadataToApiMetadataEntity(ApiMetadata apiMetadata) {
        if (apiMetadata == null) {
            return null;
        }
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(apiMetadata.getKey());
        apiMetadataEntity.setName(apiMetadata.getName());
        apiMetadataEntity.setFormat(this.metadataFormatToMetadataFormat(apiMetadata.getFormat()));
        apiMetadataEntity.setValue(apiMetadata.getValue());
        apiMetadataEntity.setDefaultValue(apiMetadata.getDefaultValue());
        apiMetadataEntity.setApiId(apiMetadata.getApiId());
        return apiMetadataEntity;
    }

    protected List<ApiMetadataEntity> apiMetadataListToApiMetadataEntityList(List<ApiMetadata> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiMetadataEntity> list1 = new ArrayList<ApiMetadataEntity>(list.size());
        for (ApiMetadata apiMetadata : list) {
            list1.add(this.apiMetadataToApiMetadataEntity(apiMetadata));
        }
        return list1;
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleStateToApiLifecycleState2(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected PropertyEntity propertyToPropertyEntity(Property property) {
        if (property == null) {
            return null;
        }
        PropertyEntity.PropertyEntityBuilder propertyEntity = PropertyEntity.builder();
        propertyEntity.key(property.getKey());
        propertyEntity.value(property.getValue());
        propertyEntity.encrypted(property.isEncrypted());
        propertyEntity.dynamic(property.isDynamic());
        return propertyEntity.build();
    }

    protected List<PropertyEntity> propertyListToPropertyEntityList(List<Property> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PropertyEntity> list1 = new ArrayList<PropertyEntity>(list.size());
        for (Property property : list) {
            list1.add(this.propertyToPropertyEntity(property));
        }
        return list1;
    }

    protected PlanEntity planToPlanEntity(Plan plan) {
        if (plan == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.id(plan.getId());
        planEntity.name(plan.getName());
        planEntity.mode(plan.getMode());
        planEntity.security(plan.getSecurity());
        planEntity.selectionRule(plan.getSelectionRule());
        Set set = plan.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet(set));
        }
        planEntity.status(plan.getStatus());
        List list = plan.getFlows();
        if (list != null) {
            planEntity.flows(new ArrayList(list));
        }
        return planEntity.build();
    }

    protected Set<PlanEntity> planListToPlanEntitySet(List<Plan> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<PlanEntity> set = LinkedHashSet.newLinkedHashSet(list.size());
        for (Plan plan : list) {
            set.add(this.planToPlanEntity(plan));
        }
        return set;
    }

    protected Visibility visibilityToVisibility2(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> null;
        };
    }

    protected Endpoint abstractEndpointToEndpoint(AbstractEndpoint abstractEndpoint) {
        if (abstractEndpoint == null) {
            return null;
        }
        Endpoint.EndpointBuilder endpoint = Endpoint.builder();
        endpoint.name(abstractEndpoint.getName());
        endpoint.type(abstractEndpoint.getType());
        endpoint.secondary(abstractEndpoint.isSecondary());
        List list = abstractEndpoint.getTenants();
        if (list != null) {
            endpoint.tenants(new ArrayList(list));
        }
        endpoint.weight(abstractEndpoint.getWeight());
        endpoint.inheritConfiguration(abstractEndpoint.isInheritConfiguration());
        endpoint.configuration(abstractEndpoint.getConfiguration());
        endpoint.sharedConfigurationOverride(abstractEndpoint.getSharedConfigurationOverride());
        return endpoint.build();
    }

    protected List<Endpoint> abstractEndpointListToEndpointList(List<? extends AbstractEndpoint> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Endpoint> list1 = new ArrayList<Endpoint>(list.size());
        for (AbstractEndpoint abstractEndpoint : list) {
            list1.add(this.abstractEndpointToEndpoint(abstractEndpoint));
        }
        return list1;
    }

    protected EndpointGroup abstractEndpointAbstractEndpointGroupToEndpointGroup(AbstractEndpointGroup<? extends AbstractEndpoint> abstractEndpointGroup) {
        if (abstractEndpointGroup == null) {
            return null;
        }
        EndpointGroup.EndpointGroupBuilder endpointGroup = EndpointGroup.builder();
        endpointGroup.name(abstractEndpointGroup.getName());
        endpointGroup.type(abstractEndpointGroup.getType());
        endpointGroup.loadBalancer(abstractEndpointGroup.getLoadBalancer());
        endpointGroup.sharedConfiguration(abstractEndpointGroup.getSharedConfiguration());
        endpointGroup.endpoints(this.abstractEndpointListToEndpointList(abstractEndpointGroup.getEndpoints()));
        return endpointGroup.build();
    }

    protected List<EndpointGroup> abstractEndpointGroupListToEndpointGroupList(List<? extends AbstractEndpointGroup<? extends AbstractEndpoint>> list) {
        if (list == null) {
            return null;
        }
        ArrayList<EndpointGroup> list1 = new ArrayList<EndpointGroup>(list.size());
        for (AbstractEndpointGroup<? extends AbstractEndpoint> abstractEndpointGroup : list) {
            list1.add(this.abstractEndpointAbstractEndpointGroupToEndpointGroup(abstractEndpointGroup));
        }
        return list1;
    }

    protected Property encryptablePropertyToProperty(EncryptableProperty encryptableProperty) {
        if (encryptableProperty == null) {
            return null;
        }
        Property.PropertyBuilder property = Property.builder();
        property.key(encryptableProperty.getKey());
        property.value(encryptableProperty.getValue());
        property.encrypted(encryptableProperty.isEncrypted());
        property.dynamic(encryptableProperty.isDynamic());
        return property.build();
    }

    protected List<Property> encryptablePropertyListToPropertyList(List<EncryptableProperty> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Property> list1 = new ArrayList<Property>(list.size());
        for (EncryptableProperty encryptableProperty : list) {
            list1.add(this.encryptablePropertyToProperty(encryptableProperty));
        }
        return list1;
    }

    protected Flow abstractFlowToFlow(AbstractFlow abstractFlow) {
        if (abstractFlow == null) {
            return null;
        }
        Flow.FlowBuilder flow = Flow.builder();
        flow.id(abstractFlow.getId());
        flow.name(abstractFlow.getName());
        flow.enabled(abstractFlow.isEnabled());
        Set set = abstractFlow.getTags();
        if (set != null) {
            flow.tags(new LinkedHashSet(set));
        }
        return flow.build();
    }

    protected List<Flow> abstractFlowListToFlowList(List<? extends AbstractFlow> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Flow> list1 = new ArrayList<Flow>(list.size());
        for (AbstractFlow abstractFlow : list) {
            list1.add(this.abstractFlowToFlow(abstractFlow));
        }
        return list1;
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState lifecycleStateToApiLifecycleState(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        switch (lifecycleState) {
            default: 
        }
        io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleState = null;
        return apiLifecycleState;
    }

    private Set<String> apiApiDefinitionNativeV4Tags(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getTags();
    }

    private List<NativeListener> apiApiDefinitionNativeV4Listeners(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getListeners();
    }

    private List<NativeEndpointGroup> apiApiDefinitionNativeV4EndpointGroups(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getEndpointGroups();
    }

    private List<NativeFlow> apiApiDefinitionNativeV4Flows(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getFlows();
    }

    private List<Resource> apiApiDefinitionNativeV4Resources(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getResources();
    }

    private NativeApiServices apiApiDefinitionNativeV4Services(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getServices();
    }

    private List<Property> apiApiDefinitionNativeV4Properties(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getProperties();
    }

    protected Lifecycle.State lifecycleStateToState(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case Api.LifecycleState.STARTED -> Lifecycle.State.STARTED;
            case Api.LifecycleState.STOPPED -> Lifecycle.State.STOPPED;
            default -> null;
        };
    }

    protected PrimaryOwnerEntity primaryOwnerEntityToPrimaryOwnerEntity(io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwnerEntity) {
        if (primaryOwnerEntity == null) {
            return null;
        }
        PrimaryOwnerEntity.PrimaryOwnerEntityBuilder primaryOwnerEntity1 = PrimaryOwnerEntity.builder();
        primaryOwnerEntity1.id(primaryOwnerEntity.id());
        primaryOwnerEntity1.email(primaryOwnerEntity.email());
        primaryOwnerEntity1.displayName(primaryOwnerEntity.displayName());
        if (primaryOwnerEntity.type() != null) {
            primaryOwnerEntity1.type(primaryOwnerEntity.type().name());
        }
        return primaryOwnerEntity1.build();
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleStateToApiLifecycleState3(ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case ApiLifecycleState.CREATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED;
            case ApiLifecycleState.PUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED;
            case ApiLifecycleState.UNPUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED;
            case ApiLifecycleState.DEPRECATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED;
            case ApiLifecycleState.ARCHIVED -> io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected Visibility visibilityToVisibility3(io.gravitee.repository.management.model.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case io.gravitee.repository.management.model.Visibility.PUBLIC -> Visibility.PUBLIC;
            case io.gravitee.repository.management.model.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> null;
        };
    }

    protected FederatedApiAgentEntity.Provider providerToProvider(FederatedAgent.Provider provider) {
        if (provider == null) {
            return null;
        }
        String organization = null;
        String url = null;
        organization = provider.organization();
        url = provider.url();
        FederatedApiAgentEntity.Provider provider1 = new FederatedApiAgentEntity.Provider(organization, url);
        return provider1;
    }

    protected FederatedApiAgentEntity.Skill skillToSkill(FederatedAgent.Skill skill) {
        Collection collection3;
        Collection collection2;
        Collection collection1;
        if (skill == null) {
            return null;
        }
        String id = null;
        String name = null;
        String description = null;
        ArrayList tags = null;
        ArrayList examples = null;
        ArrayList inputModes = null;
        ArrayList outputModes = null;
        id = skill.id();
        name = skill.name();
        description = skill.description();
        Collection collection = skill.tags();
        if (collection != null) {
            tags = new ArrayList(collection);
        }
        if ((collection1 = skill.examples()) != null) {
            examples = new ArrayList(collection1);
        }
        if ((collection2 = skill.inputModes()) != null) {
            inputModes = new ArrayList(collection2);
        }
        if ((collection3 = skill.outputModes()) != null) {
            outputModes = new ArrayList(collection3);
        }
        FederatedApiAgentEntity.Skill skill1 = new FederatedApiAgentEntity.Skill(id, name, description, tags, examples, inputModes, outputModes);
        return skill1;
    }

    protected Collection<FederatedApiAgentEntity.Skill> skillCollectionToSkillCollection(Collection<FederatedAgent.Skill> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<FederatedApiAgentEntity.Skill> collection1 = new ArrayList<FederatedApiAgentEntity.Skill>(collection.size());
        for (FederatedAgent.Skill skill : collection) {
            collection1.add(this.skillToSkill(skill));
        }
        return collection1;
    }

    protected Api.LifecycleState stateToLifecycleState(Lifecycle.State state) {
        if (state == null) {
            return null;
        }
        return switch (state) {
            case Lifecycle.State.STOPPED -> Api.LifecycleState.STOPPED;
            case Lifecycle.State.STARTED -> Api.LifecycleState.STARTED;
            default -> null;
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState4(io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected Api.Visibility visibilityToVisibility4(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> null;
        };
    }
}

