/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiLoggingConditionUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLoggingConditionUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiService apiService;
    @Autowired
    private EventService eventService;
    private List<String> apisFixedAndDeployed = new ArrayList<String>();
    private List<String> apisFixed = new ArrayList<String>();

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::applyUpgrade);
    }

    private boolean applyUpgrade() throws TechnicalException {
        for (Environment environment : this.environmentRepository.findAll()) {
            this.fixApis(new ExecutionContext(environment));
        }
        if (!this.apisFixedAndDeployed.isEmpty()) {
            log.info("{} has updated and deployed {} API with the following identifiers: {}", new Object[]{this.getClass().getSimpleName(), this.apisFixedAndDeployed.size(), this.apisFixedAndDeployed});
        }
        if (!this.apisFixed.isEmpty()) {
            log.warn("{} has updated {} API with the following identifiers: {}", new Object[]{this.getClass().getSimpleName(), this.apisFixed.size(), this.apisFixed});
            log.warn("They need to be redeployed manually to apply the patch.");
        }
        return true;
    }

    protected void fixApis(ExecutionContext executionContext) {
        this.apiRepository.search(this.getDefaultApiCriteriaBuilder().environmentId(executionContext.getEnvironmentId()).build(), null, new ApiFieldFilter.Builder().excludePicture().build()).forEach(api -> {
            try {
                String condition;
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                if (apiDefinition.getProxy() != null && apiDefinition.getProxy().getLogging() != null && apiDefinition.getProxy().getLogging().getCondition() != null && (condition = apiDefinition.getProxy().getLogging().getCondition().trim()).contains("#") && !condition.startsWith("{") && !condition.endsWith("}")) {
                    this.fixLoggingCondition(executionContext, (Api)api, apiDefinition, condition);
                }
            }
            catch (Exception e) {
                log.error("Unable to fix logging condition for API {}", (Object)api.getId(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    protected void fixLoggingCondition(ExecutionContext executionContext, Api api, io.gravitee.definition.model.Api apiDefinition, String condition) throws Exception {
        apiDefinition.getProxy().getLogging().setCondition("{" + condition + "}");
        api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
        ApiDeploymentEntity apiDeploymentEntity = null;
        if (this.apiService.isSynchronized(executionContext, api.getId())) {
            apiDeploymentEntity = new ApiDeploymentEntity();
            apiDeploymentEntity.setDeploymentLabel("Auto-deployed - 3.15.7 upgrade");
        }
        this.updateApi(executionContext, api, apiDeploymentEntity);
    }

    public int getOrder() {
        return 550;
    }

    private void updateApi(ExecutionContext executionContext, Api api, ApiDeploymentEntity apiDeploymentEntity) throws Exception {
        api.setUpdatedAt(new Date());
        api.setDeployedAt(api.getUpdatedAt());
        api = (Api)this.apiRepository.update((Object)api);
        if (apiDeploymentEntity != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            api.setPicture(null);
            this.addDeploymentLabelToProperties(executionContext, api.getId(), properties, apiDeploymentEntity);
            this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.PUBLISH_API, api, properties);
            this.apisFixedAndDeployed.add(api.getId());
        } else {
            this.apisFixed.add(api.getId());
        }
    }

    private void addDeploymentLabelToProperties(ExecutionContext executionContext, String apiId, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        Optional<EventEntity> optEvent;
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        if (executionContext.hasOrganizationId()) {
            query.setOrganizationIds(Set.of(executionContext.getOrganizationId()));
        }
        if (executionContext.hasEnvironmentId()) {
            query.setEnvironmentIds(Set.of(executionContext.getEnvironmentId()));
        }
        String lastDeployNumber = (optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt))).isPresent() ? optEvent.get().getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0") : "0";
        String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
        properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
        if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
            properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
        }
    }

    private ApiCriteria.Builder getDefaultApiCriteriaBuilder() {
        ArrayList<DefinitionVersion> allowedDefinitionVersion = new ArrayList<DefinitionVersion>();
        allowedDefinitionVersion.add(null);
        allowedDefinitionVersion.add(DefinitionVersion.V1);
        allowedDefinitionVersion.add(DefinitionVersion.V2);
        return new ApiCriteria.Builder().definitionVersion(allowedDefinitionVersion);
    }
}

