/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.rest.api.service.impl.search.lucene.analyzer.CustomWhitespaceAnalyzer;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentSearcher
implements DocumentSearcher {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_TYPE = "type";
    protected static final String FIELD_API_TYPE_VALUE = "api";
    protected Analyzer analyzer = new CustomWhitespaceAnalyzer();
    protected IndexWriter indexWriter;

    protected static void increaseMaxClauseCountIfNecessary(int size) {
        if (size > IndexSearcher.getMaxClauseCount()) {
            IndexSearcher.setMaxClauseCount((int)Math.min(size + 100, Integer.MAX_VALUE));
        }
    }

    protected AbstractDocumentSearcher(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    protected SearchResult search(Query query) throws TechnicalException {
        return this.search(query, null, null, FIELD_ID);
    }

    protected SearchResult search(Query query, Sortable sortable) throws TechnicalException {
        return this.search(query, sortable, null, FIELD_ID);
    }

    public SearchResult searchReference(Query query) throws TechnicalException {
        return this.search(query, null, null, "reference_id");
    }

    protected SearchResult search(Query query, Sortable sort, Pageable pageable) throws TechnicalException {
        return this.search(query, sort, pageable, FIELD_ID);
    }

    protected SearchResult search(Query query, Sortable sort, Pageable pageable, String fieldReference) throws TechnicalException {
        this.logger.debug("Searching for: {}", (Object)query.toString());
        try {
            Object topDocs;
            IndexSearcher searcher = this.getIndexSearcher();
            if (pageable != null) {
                TopScoreDocCollectorManager collectorManager = new TopScoreDocCollectorManager(1000, null, 1000);
                searcher.search(query, (CollectorManager)collectorManager);
                topDocs = collectorManager.newCollector().topDocs((pageable.getPageNumber() - 1) * pageable.getPageSize(), pageable.getPageSize());
            } else {
                topDocs = sort != null ? searcher.search(query, Integer.MAX_VALUE, this.convert(sort)) : searcher.search(query, Integer.MAX_VALUE);
            }
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            this.logger.debug("Found {} total matching documents", (Object)topDocs.totalHits);
            for (ScoreDoc doc : topDocs.scoreDocs) {
                String reference = searcher.storedFields().document(doc.doc).get(fieldReference);
                results.add(reference);
            }
            return new SearchResult(results, topDocs.totalHits.value());
        }
        catch (IOException ioe) {
            this.logger.error("An error occurs while getting documents from search result", (Throwable)ioe);
            throw new TechnicalException("An error occurs while getting documents from search result", (Throwable)ioe);
        }
    }

    protected Sort convert(Sortable sort) {
        if (sort != null) {
            return new Sort(new SortField[]{new SortField(sort.getField() + "_sorted", SortField.Type.STRING, !sort.isAscOrder())});
        }
        return null;
    }

    protected IndexSearcher getIndexSearcher() throws IOException {
        return new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.indexWriter));
    }

    protected Optional<Query> buildFilterQuery(Map<String, Object> filters, Map<String, String> remapFields) {
        if (filters == null || filters.isEmpty()) {
            return Optional.empty();
        }
        List queries = filters.entrySet().stream().flatMap(e -> this.prepareQuery((String)e.getKey(), e.getValue(), remapFields)).toList();
        return switch (queries.size()) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of((Query)queries.getFirst());
            default -> {
                BooleanQuery.Builder filtersQuery = new BooleanQuery.Builder();
                queries.forEach(v -> filtersQuery.add(new BooleanClause(v, BooleanClause.Occur.MUST)));
                filtersQuery.add((Query)filtersQuery.build(), BooleanClause.Occur.MUST);
                yield Optional.of(filtersQuery.build());
            }
        };
    }

    private Stream<Query> prepareQuery(String field, Object values, Map<String, String> remapFields) {
        if (Collection.class.isAssignableFrom(values.getClass())) {
            Collection valuesAsCollection = (Collection)values;
            AbstractDocumentSearcher.increaseMaxClauseCountIfNecessary(valuesAsCollection.size());
            BooleanQuery.Builder filterApisQuery = new BooleanQuery.Builder();
            valuesAsCollection.forEach(value -> filterApisQuery.add((Query)new TermQuery(new Term(remapFields.getOrDefault(field, field), (String)value)), BooleanClause.Occur.SHOULD));
            if (!valuesAsCollection.isEmpty()) {
                return Stream.of(filterApisQuery.build());
            }
        } else if (values instanceof String) {
            String value2 = (String)values;
            return Stream.of(new TermQuery(new Term(remapFields.getOrDefault(field, field), QueryParserBase.escape((String)value2))));
        }
        return Stream.empty();
    }
}

