/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.NewPreRegisterUserEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.RegisterUserEntity;
import io.gravitee.rest.api.model.ResetPasswordUserEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.JWTHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface UserService {
    public UserEntity connect(ExecutionContext var1, String var2);

    public UserEntity findById(ExecutionContext var1, String var2, boolean var3);

    default public UserEntity findById(ExecutionContext executionContext, String id) {
        return this.findById(executionContext, id, false);
    }

    public List<UserEntity> findByEmail(ExecutionContext var1, String var2);

    public UserEntity findByIdWithRoles(ExecutionContext var1, String var2);

    public UserEntity findBySource(String var1, String var2, String var3, boolean var4);

    public Set<UserEntity> findByIds(ExecutionContext var1, Collection<String> var2);

    public Set<UserEntity> findByIds(ExecutionContext var1, Collection<String> var2, boolean var3);

    public UserEntity create(ExecutionContext var1, NewExternalUserEntity var2, boolean var3);

    public UserEntity update(ExecutionContext var1, String var2, UpdateUserEntity var3);

    public UserEntity update(ExecutionContext var1, String var2, UpdateUserEntity var3, String var4);

    public Page<UserEntity> search(ExecutionContext var1, String var2, Pageable var3);

    public Page<UserEntity> search(ExecutionContext var1, UserCriteria var2, Pageable var3);

    public UserEntity register(ExecutionContext var1, NewExternalUserEntity var2);

    public UserEntity register(ExecutionContext var1, NewExternalUserEntity var2, String var3);

    public UserEntity finalizeRegistration(ExecutionContext var1, RegisterUserEntity var2);

    public UserEntity finalizeResetPassword(ExecutionContext var1, ResetPasswordUserEntity var2);

    public UserEntity processRegistration(ExecutionContext var1, String var2, boolean var3);

    public PictureEntity getPicture(ExecutionContext var1, String var2);

    public void delete(ExecutionContext var1, String var2);

    public void resetPassword(ExecutionContext var1, String var2);

    public UserEntity resetPasswordFromSourceId(ExecutionContext var1, String var2, String var3);

    public Map<String, Object> getTokenRegistrationParams(ExecutionContext var1, UserEntity var2, String var3, JWTHelper.ACTION var4);

    public Map<String, Object> getTokenRegistrationParams(ExecutionContext var1, UserEntity var2, String var3, JWTHelper.ACTION var4, String var5);

    public UserEntity create(ExecutionContext var1, NewPreRegisterUserEntity var2);

    public UserEntity createOrUpdateUserFromSocialIdentityProvider(ExecutionContext var1, SocialIdentityProviderEntity var2, String var3);

    public void updateUserRoles(ExecutionContext var1, String var2, MembershipReferenceType var3, String var4, List<String> var5);
}

