/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.monitoring.MonitoringRepository;
import io.gravitee.repository.monitoring.model.MonitoringResponse;
import io.gravitee.rest.api.model.monitoring.MonitoringCPU;
import io.gravitee.rest.api.model.monitoring.MonitoringData;
import io.gravitee.rest.api.model.monitoring.MonitoringGC;
import io.gravitee.rest.api.model.monitoring.MonitoringJVM;
import io.gravitee.rest.api.model.monitoring.MonitoringProcess;
import io.gravitee.rest.api.model.monitoring.MonitoringThread;
import io.gravitee.rest.api.service.MonitoringService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MonitoringServiceImpl
implements MonitoringService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringServiceImpl.class);
    @Lazy
    @Inject
    private MonitoringRepository monitoringRepository;

    @Override
    public MonitoringData findMonitoring(ExecutionContext executionContext, String gatewayId) {
        LOGGER.debug("Running monitoring query for Gateway instance '{}'", (Object)gatewayId);
        MonitoringResponse monitoringResponse = this.monitoringRepository.query(executionContext.getQueryContext(), gatewayId);
        return monitoringResponse != null ? this.convert(monitoringResponse) : null;
    }

    private MonitoringData convert(MonitoringResponse monitoringResponse) {
        MonitoringData monitoringData = new MonitoringData();
        if (monitoringResponse == null) {
            return monitoringData;
        }
        monitoringData.setCpu(this.convertCPU(monitoringResponse));
        monitoringData.setGc(this.convertGC(monitoringResponse));
        monitoringData.setJvm(this.convertJVM(monitoringResponse));
        monitoringData.setProcess(this.convertProcess(monitoringResponse));
        monitoringData.setThread(this.convertThread(monitoringResponse));
        return monitoringData;
    }

    private MonitoringCPU convertCPU(MonitoringResponse monitoringResponse) {
        MonitoringCPU monitoringCPU = new MonitoringCPU();
        monitoringCPU.setLoadAverage(monitoringResponse.getOsCPULoadAverage());
        monitoringCPU.setPercentUse(monitoringResponse.getOsCPUPercent());
        return monitoringCPU;
    }

    private MonitoringGC convertGC(MonitoringResponse monitoringResponse) {
        MonitoringGC monitoringGC = new MonitoringGC();
        monitoringGC.setOldCollectionCount(monitoringResponse.getJvmGCCollectorsOldCollectionCount());
        monitoringGC.setOldCollectionTimeInMillis(monitoringResponse.getJvmGCCollectorsOldCollectionTimeInMillis());
        monitoringGC.setYoungCollectionCount(monitoringResponse.getJvmGCCollectorsYoungCollectionCount());
        monitoringGC.setYoungCollectionTimeInMillis(monitoringResponse.getJvmGCCollectorsYoungCollectionTimeInMillis());
        return monitoringGC;
    }

    private MonitoringJVM convertJVM(MonitoringResponse monitoringResponse) {
        MonitoringJVM monitoringJVM = new MonitoringJVM();
        monitoringJVM.setTimestamp(monitoringResponse.getJvmTimestamp());
        monitoringJVM.setHeapCommittedInBytes(monitoringResponse.getJvmHeapCommittedInBytes());
        monitoringJVM.setHeapMaxInBytes(monitoringResponse.getJvmHeapMaxInBytes());
        monitoringJVM.setHeapUsedInBytes(monitoringResponse.getJvmHeapUsedInBytes());
        monitoringJVM.setHeapUsedPercent(monitoringResponse.getJvmHeapUsedPercent());
        monitoringJVM.setNonHeapCommittedInBytes(monitoringResponse.getJvmNonHeapCommittedInBytes());
        monitoringJVM.setNonHeapUsedInBytes(monitoringResponse.getJvmNonHeapUsedInBytes());
        monitoringJVM.setUptimeInMillis(monitoringResponse.getJvmUptimeInMillis());
        monitoringJVM.setYoungPoolMaxInBytes(monitoringResponse.getJvmMemPoolYoungMaxInBytes());
        monitoringJVM.setYoungPoolPeakMaxInBytes(monitoringResponse.getJvmMemPoolYoungPeakMaxInBytes());
        monitoringJVM.setYoungPoolPeakUsedInBytes(monitoringResponse.getJvmMemPoolYoungPeakUsedInBytes());
        monitoringJVM.setYoungPoolUsedInBytes(monitoringResponse.getJvmMemPoolYoungUsedInBytes());
        monitoringJVM.setSurvivorPoolMaxInBytes(monitoringResponse.getJvmMemPoolSurvivorMaxInBytes());
        monitoringJVM.setSurvivorPoolPeakMaxInBytes(monitoringResponse.getJvmMemPoolSurvivorPeakMaxInBytes());
        monitoringJVM.setSurvivorPoolPeakUsedInBytes(monitoringResponse.getJvmMemPoolSurvivorPeakUsedInBytes());
        monitoringJVM.setSurvivorPoolUsedInBytes(monitoringResponse.getJvmMemPoolSurvivorUsedInBytes());
        monitoringJVM.setOldPoolMaxInBytes(monitoringResponse.getJvmMemPoolOldMaxInBytes());
        monitoringJVM.setOldPoolPeakMaxInBytes(monitoringResponse.getJvmMemPoolOldPeakMaxInBytes());
        monitoringJVM.setOldPoolPeakUsedInBytes(monitoringResponse.getJvmMemPoolOldPeakUsedInBytes());
        monitoringJVM.setOldPoolUsedInBytes(monitoringResponse.getJvmMemPoolOldUsedInBytes());
        return monitoringJVM;
    }

    private MonitoringProcess convertProcess(MonitoringResponse monitoringResponse) {
        MonitoringProcess monitoringProcess = new MonitoringProcess();
        monitoringProcess.setOpenFileDescriptors(monitoringResponse.getProcessOpenFileDescriptors());
        monitoringProcess.setMaxFileDescriptors(monitoringResponse.getProcessMaxFileDescriptors());
        monitoringProcess.setCpuPercent(monitoringResponse.getProcessCPUPercent());
        return monitoringProcess;
    }

    private MonitoringThread convertThread(MonitoringResponse monitoringResponse) {
        MonitoringThread monitoringThread = new MonitoringThread();
        monitoringThread.setCount(monitoringResponse.getJvmThreadCount());
        monitoringThread.setPeakCount(monitoringResponse.getJvmThreadPeakCount());
        return monitoringThread;
    }
}

