/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.factory.PlanModelFactory;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.AbstractListener;
import io.gravitee.rest.api.service.common.IdBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidatePlanDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatePlanDomainService.class);
    private final PlanValidatorDomainService planValidator;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        if (input.plans() == null || input.plans().isEmpty()) {
            log.debug("no plans to validate and sanitize");
            return Validator.Result.ofValue(input);
        }
        log.debug("validating plans");
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, PlanCRD> sanitizedPlans = new HashMap<String, PlanCRD>();
        input.plans.forEach((k, planCRD) -> {
            try {
                Plan plan = PlanModelFactory.fromCRDSpec(planCRD, input.apiCRDSpec);
                if (planCRD.getId() == null && input.apiCRDSpec.getHrid() != null) {
                    planCRD.setId(IdBuilder.builder(input.auditInfo, input.apiCRDSpec.getHrid()).withExtraId((String)k).buildId());
                }
                this.planValidator.validatePlanSecurity(plan, input.auditInfo.organizationId(), input.auditInfo.environmentId(), ApiType.valueOf((String)input.apiCRDSpec.getType()));
                this.planValidator.validatePlanTagsAgainstApiTags(plan.getPlanTags(), input.apiCRDSpec.getTags());
                this.planValidator.validateGeneralConditionsPageStatus(plan);
                this.planValidator.validatePlanSecurityAgainstEntrypoints(plan.getPlanSecurity(), input.apiCRDSpec.getListeners().stream().map(AbstractListener::getType).toList());
                sanitizedPlans.put((String)k, (PlanCRD)planCRD);
            }
            catch (Exception e) {
                errors.add(Validator.Error.severe("invalid plan [%s]. Error: %s", k, e.getMessage()));
            }
        });
        return Validator.Result.ofBoth(input.sanitized(sanitizedPlans), errors);
    }

    @Generated
    public ValidatePlanDomainService(PlanValidatorDomainService planValidator) {
        this.planValidator = planValidator;
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec apiCRDSpec, Map<String, PlanCRD> plans) implements Validator.Input
    {
        Input sanitized(Map<String, PlanCRD> sanitizedPages) {
            return new Input(this.auditInfo, this.apiCRDSpec, sanitizedPages);
        }
    }
}

