/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.theme;

import io.gravitee.apim.core.theme.domain_service.ThemePortalNextAssetsDomainService;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThemePortalNextAssetsDomainServiceImpl
implements ThemePortalNextAssetsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThemePortalNextAssetsDomainServiceImpl.class);
    private final String themeNextPath;

    public ThemePortalNextAssetsDomainServiceImpl(@Value(value="${portal.themes.path:${gravitee.home}/themes}/next") String themeNextPath) {
        this.themeNextPath = themeNextPath;
    }

    @Override
    public String getPortalNextLogo() {
        return this.getImage("logo.png");
    }

    @Override
    public String getPortalNextFavicon() {
        return this.getImage("favicon.png");
    }

    private String getImage(String filename) {
        String filepath = this.themeNextPath + "/" + filename;
        File imageFile = new File(filepath);
        if (!imageFile.exists()) {
            return null;
        }
        try {
            byte[] image = Files.readAllBytes(imageFile.toPath());
            MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
            return "data:" + fileTypeMap.getContentType(filename) + ";base64," + Base64.getEncoder().encodeToString(image);
        }
        catch (IOException ex) {
            String error = "Error while trying to load image from: " + filepath;
            log.error(error, (Throwable)ex);
            return null;
        }
    }
}

