/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.infra.adapter.EventAdapter;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.rest.api.model.EventEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

public class EventAdapterImpl
implements EventAdapter {
    @Override
    public io.gravitee.apim.core.event.model.Event map(Event source) {
        if (source == null) {
            return null;
        }
        Event.EventBuilder<?, ?> event = io.gravitee.apim.core.event.model.Event.builder();
        event.id(source.getId());
        event.type(this.eventTypeToEventType(source.getType()));
        event.payload(source.getPayload());
        event.parentId(source.getParentId());
        Set set = source.getEnvironments();
        if (set != null) {
            event.environments(new LinkedHashSet<String>(set));
        }
        if (source.getCreatedAt() != null) {
            event.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            event.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        event.properties(this.computeEventProperties(source.getProperties()));
        return event.build();
    }

    @Override
    public io.gravitee.apim.core.event.model.Event fromEntity(EventEntity source) {
        if (source == null) {
            return null;
        }
        Event.EventBuilder<?, ?> event = io.gravitee.apim.core.event.model.Event.builder();
        event.id(source.getId());
        event.type(source.getType());
        event.payload(source.getPayload());
        event.parentId(source.getParentId());
        Set set = source.getEnvironments();
        if (set != null) {
            event.environments(new LinkedHashSet<String>(set));
        }
        if (source.getCreatedAt() != null) {
            event.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            event.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        event.properties(this.computeEventProperties(source.getProperties()));
        return event.build();
    }

    @Override
    public EventEntity toEntity(io.gravitee.apim.core.event.model.Event source) {
        Set<String> set;
        if (source == null) {
            return null;
        }
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(source.getId());
        eventEntity.setType(source.getType());
        eventEntity.setPayload(source.getPayload());
        eventEntity.setParentId(source.getParentId());
        eventEntity.setProperties(this.toStringEventPropertiesMap(source.getProperties()));
        if (source.getCreatedAt() != null) {
            eventEntity.setCreatedAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            eventEntity.setUpdatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        if ((set = source.getEnvironments()) != null) {
            eventEntity.setEnvironments(new LinkedHashSet<String>(set));
        }
        return eventEntity;
    }

    protected io.gravitee.rest.api.model.EventType eventTypeToEventType(EventType eventType) {
        if (eventType == null) {
            return null;
        }
        return switch (eventType) {
            case EventType.PUBLISH_API -> io.gravitee.rest.api.model.EventType.PUBLISH_API;
            case EventType.PUBLISH_API_RESULT -> io.gravitee.rest.api.model.EventType.PUBLISH_API_RESULT;
            case EventType.UNPUBLISH_API -> io.gravitee.rest.api.model.EventType.UNPUBLISH_API;
            case EventType.UNPUBLISH_API_RESULT -> io.gravitee.rest.api.model.EventType.UNPUBLISH_API_RESULT;
            case EventType.START_API -> io.gravitee.rest.api.model.EventType.START_API;
            case EventType.STOP_API -> io.gravitee.rest.api.model.EventType.STOP_API;
            case EventType.GATEWAY_STARTED -> io.gravitee.rest.api.model.EventType.GATEWAY_STARTED;
            case EventType.GATEWAY_STOPPED -> io.gravitee.rest.api.model.EventType.GATEWAY_STOPPED;
            case EventType.PUBLISH_DICTIONARY -> io.gravitee.rest.api.model.EventType.PUBLISH_DICTIONARY;
            case EventType.UNPUBLISH_DICTIONARY -> io.gravitee.rest.api.model.EventType.UNPUBLISH_DICTIONARY;
            case EventType.START_DICTIONARY -> io.gravitee.rest.api.model.EventType.START_DICTIONARY;
            case EventType.STOP_DICTIONARY -> io.gravitee.rest.api.model.EventType.STOP_DICTIONARY;
            case EventType.PUBLISH_ORGANIZATION -> io.gravitee.rest.api.model.EventType.PUBLISH_ORGANIZATION;
            case EventType.PUBLISH_ORGANIZATION_LICENSE -> io.gravitee.rest.api.model.EventType.PUBLISH_ORGANIZATION_LICENSE;
            case EventType.DEBUG_API -> io.gravitee.rest.api.model.EventType.DEBUG_API;
            case EventType.DEPLOY_SHARED_POLICY_GROUP -> io.gravitee.rest.api.model.EventType.DEPLOY_SHARED_POLICY_GROUP;
            case EventType.UNDEPLOY_SHARED_POLICY_GROUP -> io.gravitee.rest.api.model.EventType.UNDEPLOY_SHARED_POLICY_GROUP;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(eventType));
        };
    }
}

