/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.factory;

import io.gravitee.apim.core.api.model.AbstractUpdateApi;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewHttpApi;
import io.gravitee.apim.core.api.model.NewNativeApi;
import io.gravitee.apim.core.api.model.UpdateNativeApi;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativeApiServices;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import java.util.stream.Collectors;

public class ApiModelFactory {
    private ApiModelFactory() {
    }

    public static Api fromNewHttpApi(NewHttpApi newHttpApi, String environmentId) {
        String id = UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)newHttpApi.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).apiDefinitionHttpV4(((Api.ApiBuilder)newHttpApi.toApiDefinitionBuilder().id(id)).build())).lifecycleState(Api.LifecycleState.STOPPED)).build();
    }

    public static Api fromNewNativeApi(NewNativeApi newNativeApi, String environmentId) {
        String id = UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)newNativeApi.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).apiDefinitionNativeV4(((NativeApi.NativeApiBuilder)newNativeApi.toNativeApiDefinitionBuilder().id(id)).build())).lifecycleState(Api.LifecycleState.STOPPED)).build();
    }

    public static Api fromCrd(ApiCRDSpec crd, String environmentId) {
        String id = crd.getId() != null ? crd.getId() : UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        Object api = ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)crd.toApiBuilder().id(id)).environmentId(environmentId)).createdAt(now)).updatedAt(now)).visibility(Api.Visibility.valueOf(crd.getVisibility()))).disableMembershipNotifications(!crd.isNotifyMembers())).build();
        if (((Api)api).isNative()) {
            ((Api)api).setApiDefinitionNativeV4(((NativeApi.NativeApiBuilder)crd.toNativeApiDefinitionBuilder().id(id)).build());
        } else {
            ((Api)api).setApiDefinitionHttpV4(((Api.ApiBuilder)crd.toApiDefinitionBuilder().id(id)).build());
        }
        return api;
    }

    public static UpdateNativeApi toUpdateNativeApi(ApiCRDSpec spec) {
        return ((UpdateNativeApi.UpdateNativeApiBuilder)((AbstractUpdateApi.AbstractUpdateApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((AbstractUpdateApi.AbstractUpdateApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((AbstractUpdateApi.AbstractUpdateApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)((UpdateNativeApi.UpdateNativeApiBuilder)UpdateNativeApi.builder().id(spec.getId())).name(spec.getName())).description(spec.getDescription())).visibility(Api.Visibility.valueOf(spec.getVisibility()))).resources(spec.getResources())).disableMembershipNotifications(!spec.isNotifyMembers())).endpointGroups(spec.getEndpointGroups() != null ? spec.getEndpointGroups() : null)).apiVersion(spec.getVersion())).definitionVersion(DefinitionVersion.valueOf((String)spec.getDefinitionVersion()))).categories(spec.getCategories())).groups(spec.getGroups())).labels(spec.getLabels() != null ? spec.getLabels().stream().collect(Collectors.toList()) : null)).lifecycleState(Api.ApiLifecycleState.valueOf(spec.getLifecycleState()))).services(spec.getServices() != null ? new NativeApiServices(spec.getServices().getDynamicProperty()) : null)).tags(spec.getTags())).listeners(spec.getListeners() != null ? spec.getListeners() : null)).flows(spec.getFlows() != null ? spec.getFlows() : null)).properties(spec.getProperties())).build();
    }

    public static Api fromApiExport(ApiExport api, String environmentId) {
        String id = api.getId() != null ? api.getId() : UuidString.generateRandom();
        ZonedDateTime now = TimeProvider.now();
        Object apiExport = ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)api.toApiBuilder().id(id)).environmentId(environmentId)).definitionVersion(api.getDefinitionVersion())).type(api.getType())).createdAt(now)).updatedAt(now)).lifecycleState(Api.LifecycleState.STOPPED)).apiLifecycleState(Api.ApiLifecycleState.CREATED)).visibility(api.getVisibility() == null ? Api.Visibility.PRIVATE : Api.Visibility.valueOf(api.getVisibility().name()));
        if (api.getType() == ApiType.NATIVE) {
            return ((Api.ApiBuilder)((Api.ApiBuilder)apiExport).apiDefinitionNativeV4(((NativeApi.NativeApiBuilder)api.toNativeApiDefinitionBuilder().id(id)).build())).build();
        }
        return ((Api.ApiBuilder)((Api.ApiBuilder)apiExport).apiDefinitionHttpV4(((Api.ApiBuilder)api.toApiDefinitionBuilder().id(id)).build())).build();
    }

    public static Api fromIntegration(IntegrationApi integrationApi, Integration integration) {
        String id = ApiModelFactory.generateFederatedApiId(integrationApi, integration);
        ZonedDateTime now = TimeProvider.now();
        String defaultVersion = "0.0.0";
        String version = integrationApi.version() != null ? integrationApi.version() : defaultVersion;
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)Api.builder().id(id)).version(version)).definitionVersion(DefinitionVersion.FEDERATED)).name(integrationApi.name())).description(integrationApi.description())).createdAt(now)).updatedAt(now)).environmentId(integration.environmentId())).lifecycleState(null)).originContext((OriginContext)new OriginContext.Integration(integration.id(), integration.name(), integration.provider()))).federatedApiDefinition(integrationApi.toFederatedApiDefinitionBuilder().id(id).build())).build();
    }

    public static Api fromIngestionJob(IntegrationApi integrationApi, AsyncJob job, Integration integration) {
        String id = ApiModelFactory.generateFederatedApiId(integrationApi, job);
        ZonedDateTime now = TimeProvider.now();
        String defaultVersion = "0.0.0";
        String version = integrationApi.version() != null ? integrationApi.version() : defaultVersion;
        return ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)Api.builder().id(id)).version(version)).definitionVersion(DefinitionVersion.FEDERATED)).name(integrationApi.name())).description(integrationApi.description())).createdAt(now)).updatedAt(now)).environmentId(job.getEnvironmentId())).lifecycleState(null)).originContext((OriginContext)new OriginContext.Integration(job.getSourceId(), integration.name(), integration.provider()))).federatedApiDefinition(integrationApi.toFederatedApiDefinitionBuilder().id(id).build())).build();
    }

    public static String generateFederatedApiId(IntegrationApi integrationApi, Integration integration) {
        return ApiModelFactory.generateFederatedApiId(integration.environmentId(), integration.id(), integrationApi);
    }

    public static String generateFederatedApiId(String environmentId, String integrationId, IntegrationApi integrationApi) {
        return UuidString.generateForEnvironment(environmentId, integrationId, integrationApi.uniqueId());
    }

    public static String generateFederatedApiId(IntegrationApi integrationApi, AsyncJob job) {
        return UuidString.generateForEnvironment(job.getEnvironmentId(), job.getSourceId(), integrationApi.uniqueId());
    }
}

