/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.federation;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.gravitee.apim.core.integration.service_provider.A2aAgentFetcher;
import io.gravitee.definition.model.federation.FederatedAgent;
import io.reactivex.rxjava3.core.Single;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.ext.web.client.HttpResponse;
import io.vertx.rxjava3.ext.web.client.WebClient;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class A2aAgentFetcherImpl
implements A2aAgentFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(A2aAgentFetcherImpl.class);
    private final Vertx vertx;
    private ObjectMapper objectMapper;
    private WebClient webClient;

    @PostConstruct
    public void init() {
        this.webClient = WebClient.create((Vertx)this.vertx);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public Single<FederatedAgent> fetchAgentCard(String url) {
        return A2aAgentFetcherImpl.executeQuery(this.webClient, url).map(r -> (FederatedAgent)this.objectMapper.readValue(r.bodyAsString(), FederatedAgent.class));
    }

    private static Single<HttpResponse<Buffer>> executeQuery(WebClient webClient, String url) {
        try {
            URL uri = new URI(url).toURL();
            int port = uri.getPort();
            if (port < 0) {
                port = switch (uri.getProtocol()) {
                    case "http" -> 80;
                    case "https" -> 443;
                    default -> throw new IllegalArgumentException("Invalid port " + uri.getPort());
                };
            }
            return webClient.get(port, uri.getHost(), uri.getFile()).rxSend();
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
    }

    @Generated
    public A2aAgentFetcherImpl(Vertx vertx) {
        this.vertx = vertx;
    }
}

