/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.scoring;

import io.gravitee.apim.core.scoring.model.ScoringFunction;
import io.gravitee.apim.core.scoring.query_service.ScoringFunctionQueryService;
import io.gravitee.apim.infra.adapter.ScoringFunctionAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringFunctionRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringFunctionQueryServiceImpl
extends AbstractService
implements ScoringFunctionQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringFunctionQueryServiceImpl.class);
    private final ScoringFunctionRepository scoringFunctionRepository;

    public ScoringFunctionQueryServiceImpl(@Lazy ScoringFunctionRepository scoringFunctionRepository) {
        this.scoringFunctionRepository = scoringFunctionRepository;
    }

    @Override
    public List<ScoringFunction> findByReference(String referenceId, ScoringFunction.ReferenceType referenceType) {
        try {
            return this.scoringFunctionRepository.findAllByReferenceId(referenceId, referenceType.name()).stream().map(ScoringFunctionAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Scoring function [{}:{}]", new Object[]{referenceType, referenceId, e});
            throw new TechnicalManagementException("An error occurred while finding Scoring function [%s:%s] ".formatted(new Object[]{referenceType, referenceId}), e);
        }
    }
}

