/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanUpdates;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

@UseCase
public class UpdatePlanUseCase {
    private final UpdatePlanDomainService updatePlanDomainService;
    private final PlanCrudService planCrudService;
    private final ApiCrudService apiCrudService;

    public Output execute(Input input) {
        Plan planEntity = this.planCrudService.findById(input.planToUpdate.getId()).orElseThrow(() -> new PlanNotFoundException(input.planToUpdate.getId()));
        if (!planEntity.getApiId().equals(input.apiId)) {
            throw new PlanNotFoundException(input.planToUpdate.getId());
        }
        Plan updatedEntity = input.planToUpdate.applyTo(planEntity);
        Api api = this.apiCrudService.get(input.apiId);
        List<? extends AbstractFlow> flows = input.flowProvider.apply(api);
        Plan updated = this.updatePlanDomainService.update(updatedEntity, flows, Map.of(), api, input.auditInfo);
        return new Output(new PlanWithFlows(updated, flows));
    }

    @Generated
    public UpdatePlanUseCase(UpdatePlanDomainService updatePlanDomainService, PlanCrudService planCrudService, ApiCrudService apiCrudService) {
        this.updatePlanDomainService = updatePlanDomainService;
        this.planCrudService = planCrudService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(PlanUpdates planToUpdate, Function<Api, List<? extends AbstractFlow>> flowProvider, String apiId, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private PlanUpdates planToUpdate;
            @Generated
            private Function<Api, List<? extends AbstractFlow>> flowProvider;
            @Generated
            private String apiId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder planToUpdate(PlanUpdates planToUpdate) {
                this.planToUpdate = planToUpdate;
                return this;
            }

            @Generated
            public InputBuilder flowProvider(Function<Api, List<? extends AbstractFlow>> flowProvider) {
                this.flowProvider = flowProvider;
                return this;
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.planToUpdate, this.flowProvider, this.apiId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdatePlanUseCase.Input.InputBuilder(planToUpdate=" + String.valueOf(this.planToUpdate) + ", flowProvider=" + String.valueOf(this.flowProvider) + ", apiId=" + this.apiId + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(PlanWithFlows updated) {
    }
}

