/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.infra.adapter.ThemeAdapter;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.rest.api.model.theme.ThemeType;
import io.gravitee.rest.api.model.theme.portal.ThemeEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ThemeAdapterImpl
implements ThemeAdapter {
    @Override
    public Theme map(io.gravitee.apim.core.theme.model.Theme theme) {
        if (theme == null) {
            return null;
        }
        Theme.ThemeBuilder theme1 = Theme.builder();
        theme1.id(theme.getId());
        if (theme.getReferenceType() != null) {
            theme1.referenceType(theme.getReferenceType().name());
        }
        theme1.referenceId(theme.getReferenceId());
        theme1.name(theme.getName());
        theme1.type(this.themeTypeToThemeType(theme.getType()));
        if (theme.getCreatedAt() != null) {
            theme1.createdAt(Date.from(theme.getCreatedAt().toInstant()));
        }
        if (theme.getUpdatedAt() != null) {
            theme1.updatedAt(Date.from(theme.getUpdatedAt().toInstant()));
        }
        theme1.enabled(theme.isEnabled());
        theme1.logo(theme.getLogo());
        theme1.backgroundImage(theme.getBackgroundImage());
        theme1.optionalLogo(theme.getOptionalLogo());
        theme1.favicon(theme.getFavicon());
        theme1.definition(this.serializeDefinition(theme));
        return theme1.build();
    }

    @Override
    public io.gravitee.apim.core.theme.model.Theme map(Theme theme) {
        if (theme == null) {
            return null;
        }
        Theme.ThemeBuilder theme1 = io.gravitee.apim.core.theme.model.Theme.builder();
        theme1.id(theme.getId());
        theme1.name(theme.getName());
        theme1.referenceId(theme.getReferenceId());
        if (theme.getReferenceType() != null) {
            theme1.referenceType(Enum.valueOf(Theme.ReferenceType.class, theme.getReferenceType()));
        }
        theme1.type(this.themeTypeToThemeType1(theme.getType()));
        if (theme.getCreatedAt() != null) {
            theme1.createdAt(ZonedDateTime.ofInstant(theme.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (theme.getUpdatedAt() != null) {
            theme1.updatedAt(ZonedDateTime.ofInstant(theme.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        theme1.enabled(theme.isEnabled());
        theme1.logo(theme.getLogo());
        theme1.optionalLogo(theme.getOptionalLogo());
        theme1.favicon(theme.getFavicon());
        theme1.backgroundImage(theme.getBackgroundImage());
        theme1.definitionPortal(this.deserializeDefinitionPortal(theme));
        theme1.definitionPortalNext(this.deserializeDefinitionPortalNext(theme));
        return theme1.build();
    }

    @Override
    public io.gravitee.apim.core.theme.model.Theme map(ThemeEntity themeEntity) {
        if (themeEntity == null) {
            return null;
        }
        Theme.ThemeBuilder theme = io.gravitee.apim.core.theme.model.Theme.builder();
        theme.definitionPortal(themeEntity.getDefinition());
        theme.id(themeEntity.getId());
        theme.name(themeEntity.getName());
        theme.type(this.themeTypeToThemeType2(themeEntity.getType()));
        if (themeEntity.getCreatedAt() != null) {
            theme.createdAt(ZonedDateTime.ofInstant(themeEntity.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (themeEntity.getUpdatedAt() != null) {
            theme.updatedAt(ZonedDateTime.ofInstant(themeEntity.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        theme.enabled(themeEntity.isEnabled());
        theme.logo(themeEntity.getLogo());
        theme.optionalLogo(themeEntity.getOptionalLogo());
        theme.favicon(themeEntity.getFavicon());
        theme.backgroundImage(themeEntity.getBackgroundImage());
        return theme.build();
    }

    @Override
    public List<io.gravitee.apim.core.theme.model.Theme> map(List<Theme> themes) {
        if (themes == null) {
            return null;
        }
        ArrayList<io.gravitee.apim.core.theme.model.Theme> list = new ArrayList<io.gravitee.apim.core.theme.model.Theme>(themes.size());
        for (Theme theme : themes) {
            list.add(this.map(theme));
        }
        return list;
    }

    @Override
    public Set<io.gravitee.apim.core.theme.model.Theme> map(Set<Theme> themes) {
        if (themes == null) {
            return null;
        }
        LinkedHashSet<io.gravitee.apim.core.theme.model.Theme> set = new LinkedHashSet<io.gravitee.apim.core.theme.model.Theme>(Math.max((int)((float)themes.size() / 0.75f) + 1, 16));
        for (Theme theme : themes) {
            set.add(this.map(theme));
        }
        return set;
    }

    protected io.gravitee.repository.management.model.ThemeType themeTypeToThemeType(io.gravitee.apim.core.theme.model.ThemeType themeType) {
        if (themeType == null) {
            return null;
        }
        return switch (themeType) {
            case io.gravitee.apim.core.theme.model.ThemeType.PORTAL -> io.gravitee.repository.management.model.ThemeType.PORTAL;
            case io.gravitee.apim.core.theme.model.ThemeType.PORTAL_NEXT -> io.gravitee.repository.management.model.ThemeType.PORTAL_NEXT;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)themeType));
        };
    }

    protected io.gravitee.apim.core.theme.model.ThemeType themeTypeToThemeType1(io.gravitee.repository.management.model.ThemeType themeType) {
        if (themeType == null) {
            return null;
        }
        return switch (themeType) {
            case io.gravitee.repository.management.model.ThemeType.PORTAL -> io.gravitee.apim.core.theme.model.ThemeType.PORTAL;
            case io.gravitee.repository.management.model.ThemeType.PORTAL_NEXT -> io.gravitee.apim.core.theme.model.ThemeType.PORTAL_NEXT;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(themeType));
        };
    }

    protected io.gravitee.apim.core.theme.model.ThemeType themeTypeToThemeType2(ThemeType themeType) {
        if (themeType == null) {
            return null;
        }
        return switch (themeType) {
            case ThemeType.PORTAL -> io.gravitee.apim.core.theme.model.ThemeType.PORTAL;
            case ThemeType.PORTAL_NEXT -> io.gravitee.apim.core.theme.model.ThemeType.PORTAL_NEXT;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(themeType));
        };
    }
}

