/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.infra.adapter.MembershipAdapter;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class MembershipAdapterImpl
implements MembershipAdapter {
    @Override
    public io.gravitee.apim.core.membership.model.Membership toEntity(Membership membership) {
        if (membership == null) {
            return null;
        }
        Membership.MembershipBuilder membership1 = io.gravitee.apim.core.membership.model.Membership.builder();
        membership1.id(membership.getId());
        membership1.memberId(membership.getMemberId());
        membership1.memberType(this.membershipMemberTypeToType(membership.getMemberType()));
        membership1.referenceType(this.membershipReferenceTypeToReferenceType(membership.getReferenceType()));
        membership1.referenceId(membership.getReferenceId());
        membership1.roleId(membership.getRoleId());
        membership1.source(membership.getSource());
        if (membership.getCreatedAt() != null) {
            membership1.createdAt(ZonedDateTime.ofInstant(membership.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (membership.getUpdatedAt() != null) {
            membership1.updatedAt(ZonedDateTime.ofInstant(membership.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return membership1.build();
    }

    @Override
    public Membership toRepository(io.gravitee.apim.core.membership.model.Membership membership) {
        if (membership == null) {
            return null;
        }
        Membership.MembershipBuilder membership1 = Membership.builder();
        membership1.id(membership.getId());
        membership1.memberId(membership.getMemberId());
        membership1.memberType(this.typeToMembershipMemberType(membership.getMemberType()));
        membership1.referenceId(membership.getReferenceId());
        membership1.referenceType(this.referenceTypeToMembershipReferenceType(membership.getReferenceType()));
        membership1.roleId(membership.getRoleId());
        membership1.source(membership.getSource());
        if (membership.getCreatedAt() != null) {
            membership1.createdAt(Date.from(membership.getCreatedAt().toInstant()));
        }
        if (membership.getUpdatedAt() != null) {
            membership1.updatedAt(Date.from(membership.getUpdatedAt().toInstant()));
        }
        return membership1.build();
    }

    protected Membership.Type membershipMemberTypeToType(MembershipMemberType membershipMemberType) {
        if (membershipMemberType == null) {
            return null;
        }
        return switch (membershipMemberType) {
            case MembershipMemberType.USER -> Membership.Type.USER;
            case MembershipMemberType.GROUP -> Membership.Type.GROUP;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(membershipMemberType));
        };
    }

    protected Membership.ReferenceType membershipReferenceTypeToReferenceType(MembershipReferenceType membershipReferenceType) {
        if (membershipReferenceType == null) {
            return null;
        }
        return switch (membershipReferenceType) {
            case MembershipReferenceType.APPLICATION -> Membership.ReferenceType.APPLICATION;
            case MembershipReferenceType.API -> Membership.ReferenceType.API;
            case MembershipReferenceType.GROUP -> Membership.ReferenceType.GROUP;
            case MembershipReferenceType.ENVIRONMENT -> Membership.ReferenceType.ENVIRONMENT;
            case MembershipReferenceType.ORGANIZATION -> Membership.ReferenceType.ORGANIZATION;
            case MembershipReferenceType.PLATFORM -> Membership.ReferenceType.PLATFORM;
            case MembershipReferenceType.INTEGRATION -> Membership.ReferenceType.INTEGRATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(membershipReferenceType));
        };
    }

    protected MembershipMemberType typeToMembershipMemberType(Membership.Type type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            case Membership.Type.USER -> MembershipMemberType.USER;
            case Membership.Type.GROUP -> MembershipMemberType.GROUP;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)type));
        };
    }

    protected MembershipReferenceType referenceTypeToMembershipReferenceType(Membership.ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        return switch (referenceType) {
            case Membership.ReferenceType.API -> MembershipReferenceType.API;
            case Membership.ReferenceType.APPLICATION -> MembershipReferenceType.APPLICATION;
            case Membership.ReferenceType.GROUP -> MembershipReferenceType.GROUP;
            case Membership.ReferenceType.ENVIRONMENT -> MembershipReferenceType.ENVIRONMENT;
            case Membership.ReferenceType.ORGANIZATION -> MembershipReferenceType.ORGANIZATION;
            case Membership.ReferenceType.PLATFORM -> MembershipReferenceType.PLATFORM;
            case Membership.ReferenceType.INTEGRATION -> MembershipReferenceType.INTEGRATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)referenceType));
        };
    }
}

