/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.domain_service.GroupValidationService;
import io.gravitee.apim.core.api.domain_service.ValidateApiLifecycleService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.DefinitionVersion;
import java.util.Set;
import lombok.Generated;

@DomainService
public class ValidateFederatedApiDomainService {
    private final GroupValidationService groupValidationService;
    private final CategoryDomainService categoryDomainService;

    public Api validateAndSanitizeForCreation(Api newApi, PrimaryOwnerEntity primaryOwner) {
        if (newApi.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            throw new ValidationDomainException("Definition version is unsupported, should be FEDERATED");
        }
        newApi.setGroups(this.groupValidationService.validateAndSanitize(Set.of(), newApi.getEnvironmentId(), primaryOwner, true));
        newApi.setLifecycleState(null);
        return newApi;
    }

    public Api validateAndSanitizeForUpdate(Api updateApi, Api existingApi, PrimaryOwnerEntity primaryOwnerEntity) {
        Set<String> groupIds = this.groupValidationService.validateAndSanitize(updateApi.getGroups(), existingApi.getEnvironmentId(), primaryOwnerEntity, false);
        updateApi.setGroups(groupIds);
        updateApi.setCategories(this.categoryDomainService.toCategoryId(updateApi, existingApi.getEnvironmentId()));
        Api.ApiLifecycleState lifecycleState = ValidateApiLifecycleService.validateFederatedApiLifecycleState(existingApi.getApiLifecycleState(), updateApi.getApiLifecycleState());
        updateApi.setApiLifecycleState(lifecycleState);
        return updateApi;
    }

    @Generated
    public ValidateFederatedApiDomainService(GroupValidationService groupValidationService, CategoryDomainService categoryDomainService) {
        this.groupValidationService = groupValidationService;
        this.categoryDomainService = categoryDomainService;
    }
}

