/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.hook.ApiDeprecatedApiHookContext;
import io.gravitee.apim.core.notification.model.hook.ApiUpdatedApiHookContext;
import io.gravitee.apim.core.plan.domain_service.DeprecatePlanDomainService;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import lombok.Generated;

@DomainService
public class UpdateNativeApiDomainService {
    private final ApiCrudService apiCrudService;
    private final PlanQueryService planQueryService;
    private final DeprecatePlanDomainService deprecatePlanDomainService;
    private final TriggerNotificationDomainService triggerNotificationDomainService;
    private final FlowCrudService flowCrudService;
    private final CategoryDomainService categoryDomainService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;

    public Api update(String apiId, UnaryOperator<Api> updater, BinaryOperator<Api> sanitizer, AuditInfo auditInfo, PrimaryOwnerEntity primaryOwnerEntity, ApiIndexerDomainService.Context ctx) {
        Api existingApi = this.apiCrudService.get(apiId);
        Api apiWithUpdatedFields = (Api)updater.apply(existingApi);
        Api api = (Api)sanitizer.apply(existingApi, apiWithUpdatedFields);
        api.setUpdatedAt(TimeProvider.now());
        if (Api.ApiLifecycleState.DEPRECATED == api.getApiLifecycleState()) {
            this.handleDeprecatedApi(api, auditInfo);
        }
        Api updatedApi = this.apiCrudService.update(api);
        this.flowCrudService.saveNativeApiFlows(updatedApi.getId(), updatedApi.getApiDefinitionNativeV4().getFlows());
        this.categoryDomainService.updateOrderCategoriesOfApi(updatedApi.getId(), updatedApi.getCategories());
        this.createAuditLog(auditInfo, updatedApi, existingApi);
        this.triggerNotificationDomainService.triggerApiNotification(auditInfo.organizationId(), auditInfo.environmentId(), new ApiUpdatedApiHookContext(api.getId()));
        updatedApi.setCategories(this.categoryDomainService.toCategoryKey(updatedApi, auditInfo.environmentId()));
        this.apiIndexerDomainService.index(ctx, updatedApi, primaryOwnerEntity);
        return updatedApi;
    }

    private void handleDeprecatedApi(Api api, AuditInfo auditInfo) {
        this.planQueryService.findAllByApiId(api.getId()).stream().filter(plan -> PlanStatus.PUBLISHED == plan.getPlanStatus() || PlanStatus.STAGING == plan.getPlanStatus()).forEach(plan -> this.deprecatePlanDomainService.deprecate(plan.getId(), auditInfo, true));
        this.triggerNotificationDomainService.triggerApiNotification(auditInfo.organizationId(), auditInfo.environmentId(), new ApiDeprecatedApiHookContext(api.getId()));
    }

    private void createAuditLog(AuditInfo auditInfo, Api updatedApi, Api currentApi) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(updatedApi.getId()).event(ApiAuditEvent.API_UPDATED).actor(auditInfo.actor()).oldValue(currentApi).newValue(updatedApi).createdAt(updatedApi.getUpdatedAt()).properties(Collections.emptyMap()).build());
    }

    @Generated
    public UpdateNativeApiDomainService(ApiCrudService apiCrudService, PlanQueryService planQueryService, DeprecatePlanDomainService deprecatePlanDomainService, TriggerNotificationDomainService triggerNotificationDomainService, FlowCrudService flowCrudService, CategoryDomainService categoryDomainService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService) {
        this.apiCrudService = apiCrudService;
        this.planQueryService = planQueryService;
        this.deprecatePlanDomainService = deprecatePlanDomainService;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
        this.flowCrudService = flowCrudService;
        this.categoryDomainService = categoryDomainService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
    }
}

