/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.node.api.license.ForbiddenFeatureException;
import io.gravitee.node.api.license.InvalidLicenseException;
import io.gravitee.node.api.license.LicenseManager;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiLicenseService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ApiLicenseServiceImpl
implements ApiLicenseService {
    private final LicenseManager licenseManager;
    private final ApiSearchService apiSearchService;
    private final ObjectMapper objectMapper;

    public ApiLicenseServiceImpl(LicenseManager licenseManager, ApiSearchService apiSearchService, ObjectMapper objectMapper) {
        this.licenseManager = licenseManager;
        this.apiSearchService = apiSearchService;
        this.objectMapper = objectMapper;
    }

    @Override
    public void checkLicense(ExecutionContext executionContext, String apiId) {
        List plugins;
        io.gravitee.repository.management.model.Api repositoryApi = this.apiSearchService.findRepositoryApiById(executionContext, apiId);
        try {
            if (DefinitionVersion.V4.equals((Object)repositoryApi.getDefinitionVersion())) {
                if (repositoryApi.getType() == ApiType.NATIVE) {
                    apiDefinition = (NativeApi)this.objectMapper.readValue(repositoryApi.getDefinition(), NativeApi.class);
                    plugins = apiDefinition.getPlugins();
                } else {
                    apiDefinition = (Api)this.objectMapper.readValue(repositoryApi.getDefinition(), Api.class);
                    plugins = apiDefinition.getPlugins();
                }
            } else if (repositoryApi.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
                apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(repositoryApi.getDefinition(), io.gravitee.definition.model.Api.class);
                plugins = apiDefinition.getPlugins();
            } else {
                plugins = Collections.emptyList();
            }
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e.getMessage());
        }
        try {
            List<LicenseManager.Plugin> licensePlugins = plugins.stream().map(p -> new LicenseManager.Plugin(p.type(), p.id())).toList();
            this.licenseManager.validatePluginFeatures(executionContext.getOrganizationId(), licensePlugins);
        }
        catch (ForbiddenFeatureException ffe) {
            throw new io.gravitee.rest.api.service.exceptions.ForbiddenFeatureException(ffe.getFeatures().stream().map(LicenseManager.ForbiddenFeature::plugin).toList());
        }
        catch (InvalidLicenseException e) {
            throw new io.gravitee.rest.api.service.exceptions.InvalidLicenseException(e.getMessage());
        }
    }
}

