/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.transformer.page;

import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.service.impl.swagger.transformer.OAITransformer;
import io.gravitee.rest.api.service.impl.swagger.transformer.page.AbstractPageConfigurationSwaggerTransformer;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Collectors;

public class PageConfigurationOAITransformer
extends AbstractPageConfigurationSwaggerTransformer<OAIDescriptor>
implements OAITransformer {
    public PageConfigurationOAITransformer(PageEntity page) {
        super(page);
    }

    @Override
    public void transform(OAIDescriptor descriptor) {
        String tryItUrl = this.asString("tryItURL");
        if (tryItUrl != null && !tryItUrl.isEmpty()) {
            URI newURI = URI.create(tryItUrl);
            descriptor.getSpecification().getServers().forEach(server -> {
                try {
                    server.setUrl(new URI(newURI.getScheme(), newURI.getUserInfo(), newURI.getHost(), newURI.getPort(), newURI.getPath(), newURI.getQuery(), newURI.getFragment()).toString());
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
            descriptor.getSpecification().servers(descriptor.getSpecification().getServers().stream().distinct().collect(Collectors.toList()));
        }
    }
}

