/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.use_case.ApiCreateDocumentationPageUseCase;
import io.gravitee.apim.core.specgen.use_case.BuildSpecGenPageResponseUseCase;
import io.gravitee.apim.core.specgen.use_case.NotifySpecGenResponseUseCase;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.specgen.SpecGenCommandPayload;
import io.gravitee.cockpit.api.command.v1.specgen.response.SpecGenResponseCommand;
import io.gravitee.cockpit.api.command.v1.specgen.response.SpecGenResponseReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.spec.gen.api.SpecGenResponse;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SpecGenResponseCommandHandler
implements CommandHandler<SpecGenResponseCommand, SpecGenResponseReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecGenResponseCommandHandler.class);
    private final BuildSpecGenPageResponseUseCase saveSpecGenResponseUseCase;
    private final ApiCreateDocumentationPageUseCase createDocumentationPageUseCase;
    private final NotifySpecGenResponseUseCase notifySpecGenResponseUseCase;

    public SpecGenResponseCommandHandler(@Lazy BuildSpecGenPageResponseUseCase saveSpecGenResponseUseCase, @Lazy ApiCreateDocumentationPageUseCase createDocumentationPageUseCase, @Lazy NotifySpecGenResponseUseCase NotifySpecGenResponseUseCase2) {
        this.saveSpecGenResponseUseCase = saveSpecGenResponseUseCase;
        this.createDocumentationPageUseCase = createDocumentationPageUseCase;
        this.notifySpecGenResponseUseCase = NotifySpecGenResponseUseCase2;
    }

    public String supportType() {
        return CockpitCommandType.SPEC_GEN_RESPONSE.name();
    }

    public Single<SpecGenResponseReply> handle(SpecGenResponseCommand command) {
        SpecGenResponse payload = (SpecGenResponse)((SpecGenCommandPayload)command.getPayload()).payload();
        return this.saveSpecGenResponseUseCase.execute(new BuildSpecGenPageResponseUseCase.Input(payload.apiId(), payload.result())).map(page -> this.createDocumentationPageUseCase.execute(new ApiCreateDocumentationPageUseCase.Input((Page)page, SpecGenResponseCommandHandler.getAuditInfo(payload.userId())))).doOnError(t -> log.error("An error has occurred while trying to save generated specification for api: [{}]", (Object)payload.apiId(), t)).ignoreElement().andThen((SingleSource)Single.just((Object)new SpecGenResponseReply(command.getId(), CommandStatus.SUCCEEDED))).onErrorResumeNext(t -> Single.just((Object)new SpecGenResponseReply(command.getId(), t.getMessage()))).doOnSuccess(reply -> {
            if (CommandStatus.SUCCEEDED.equals((Object)reply.getCommandStatus())) {
                this.notifySpecGenResponseUseCase.notify(payload.apiId(), payload.userId());
            }
        });
    }

    private static AuditInfo getAuditInfo(String userId) {
        ExecutionContext context = GraviteeContext.getExecutionContext();
        return AuditInfo.builder().environmentId(context.getEnvironmentId()).organizationId(context.getOrganizationId()).actor(AuditActor.builder().userId(userId).build()).build();
    }
}

