/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.membership;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.infra.adapter.MembershipAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import java.util.Collection;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MembershipQueryServiceImpl
implements MembershipQueryService {
    private final MembershipRepository membershipRepository;

    public MembershipQueryServiceImpl(@Lazy MembershipRepository membershipRepository) {
        this.membershipRepository = membershipRepository;
    }

    @Override
    public Collection<Membership> findByReferenceAndRoleId(Membership.ReferenceType referenceType, String referenceId, String roleId) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.valueOf((String)referenceType.name()), referenceId, roleId).stream().map(MembershipAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to find %s membership", new Object[]{referenceType}), e);
        }
    }

    @Override
    public Collection<Membership> findByReferencesAndRoleId(Membership.ReferenceType referenceType, List<String> referenceIds, String roleId) {
        try {
            return this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.valueOf((String)referenceType.name()), referenceIds, roleId).stream().map(MembershipAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to find %s membership", new Object[]{referenceType}), e);
        }
    }

    @Override
    public Collection<Membership> findByReference(Membership.ReferenceType referenceType, String referenceId) {
        return this.findByReferenceAndRoleId(referenceType, referenceId, null);
    }

    @Override
    public Collection<Membership> findGroupsThatUserBelongsTo(String memberId) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(memberId, MembershipMemberType.USER, MembershipReferenceType.GROUP).stream().map(MembershipAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to find Group memberships of member %s", memberId), e);
        }
    }
}

