/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.member;

import io.gravitee.apim.core.member.model.Member;
import io.gravitee.apim.core.member.model.MembershipMember;
import io.gravitee.apim.core.member.model.MembershipMemberType;
import io.gravitee.apim.core.member.model.MembershipReference;
import io.gravitee.apim.core.member.model.MembershipRole;
import io.gravitee.apim.core.member.query_service.MemberQueryService;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.apim.infra.adapter.MembershipMemberAdapter;
import io.gravitee.apim.infra.adapter.MembershipReferenceAdapter;
import io.gravitee.apim.infra.adapter.MembershipRoleAdapter;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MemberQueryServiceLegacyWrapper
implements MemberQueryService {
    private final MembershipService membershipService;

    public MemberQueryServiceLegacyWrapper(MembershipService membershipService) {
        this.membershipService = membershipService;
    }

    @Override
    public Set<Member> getMembersByReference(io.gravitee.apim.core.member.model.MembershipReferenceType referenceType, String referenceId) {
        return this.membershipService.getMembersByReference(GraviteeContext.getExecutionContext(), MembershipReferenceType.valueOf((String)referenceType.name()), referenceId).stream().map(MemberAdapter.INSTANCE::toMember).collect(Collectors.toSet());
    }

    @Override
    public Member getUserMember(io.gravitee.apim.core.member.model.MembershipReferenceType referenceType, String referenceId, String userId) {
        MemberEntity userMember = this.membershipService.getUserMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.valueOf((String)referenceType.name()), referenceId, userId);
        return MemberAdapter.INSTANCE.toMember(userMember);
    }

    @Override
    public Member updateRoleToMemberOnReference(MembershipReference reference, MembershipMember member, MembershipRole role) {
        MemberEntity memberEntity = this.membershipService.updateRoleToMemberOnReference(GraviteeContext.getExecutionContext(), MembershipReferenceAdapter.INSTANCE.map(reference), MembershipMemberAdapter.INSTANCE.map(member), MembershipRoleAdapter.INSTANCE.map(role));
        return MemberAdapter.INSTANCE.toMember(memberEntity);
    }

    @Override
    public void addRoleToMemberOnReference(MembershipReference reference, MembershipMember member, MembershipRole role) {
        this.membershipService.addRoleToMemberOnReference(GraviteeContext.getExecutionContext(), MembershipReferenceAdapter.INSTANCE.map(reference), MembershipMemberAdapter.INSTANCE.map(member), MembershipRoleAdapter.INSTANCE.map(role));
    }

    @Override
    public void deleteReferenceMember(io.gravitee.apim.core.member.model.MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId) {
        this.membershipService.deleteReferenceMember(GraviteeContext.getExecutionContext(), MembershipReferenceType.valueOf((String)referenceType.name()), referenceId, io.gravitee.rest.api.model.MembershipMemberType.valueOf((String)memberType.name()), memberId);
    }
}

