/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.infra.adapter.WorkflowAdapter;
import io.gravitee.repository.management.model.Workflow;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WorkflowAdapterImpl
implements WorkflowAdapter {
    @Override
    public Workflow toEntity(io.gravitee.repository.management.model.Workflow source) {
        if (source == null) {
            return null;
        }
        Workflow.WorkflowBuilder workflow = Workflow.builder();
        workflow.id(source.getId());
        if (source.getReferenceType() != null) {
            workflow.referenceType(Enum.valueOf(Workflow.ReferenceType.class, source.getReferenceType()));
        }
        workflow.referenceId(source.getReferenceId());
        if (source.getType() != null) {
            workflow.type(Enum.valueOf(Workflow.Type.class, source.getType()));
        }
        if (source.getState() != null) {
            workflow.state(Enum.valueOf(Workflow.State.class, source.getState()));
        }
        workflow.comment(source.getComment());
        workflow.user(source.getUser());
        if (source.getCreatedAt() != null) {
            workflow.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return workflow.build();
    }

    @Override
    public List<Workflow> toEntities(List<io.gravitee.repository.management.model.Workflow> source) {
        if (source == null) {
            return null;
        }
        ArrayList<Workflow> list = new ArrayList<Workflow>(source.size());
        for (io.gravitee.repository.management.model.Workflow workflow : source) {
            list.add(this.toEntity(workflow));
        }
        return list;
    }

    @Override
    public io.gravitee.repository.management.model.Workflow toRepository(Workflow source) {
        if (source == null) {
            return null;
        }
        Workflow.WorkflowBuilder workflow = io.gravitee.repository.management.model.Workflow.builder();
        workflow.id(source.getId());
        if (source.getReferenceType() != null) {
            workflow.referenceType(source.getReferenceType().name());
        }
        workflow.referenceId(source.getReferenceId());
        if (source.getType() != null) {
            workflow.type(source.getType().name());
        }
        if (source.getState() != null) {
            workflow.state(source.getState().name());
        }
        workflow.comment(source.getComment());
        workflow.user(source.getUser());
        if (source.getCreatedAt() != null) {
            workflow.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        return workflow.build();
    }
}

